/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.items;

import com.rwtema.careerbees.effects.EffectBase;
import forestry.api.apiculture.IBeeHousing;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class DelayedInsertionHelper {
    private static final WeakHashMap<IBeeHousing, TObjectIntHashMap<InsertEntry>> map = new WeakHashMap();

    public static ItemStack addEntityStack(@Nonnull ItemStack stack, @Nonnull IBeeHousing housing, @Nonnull Entity item) {
        return DelayedInsertionHelper.addStack(stack, housing, new Vec3d(item.field_70165_t, item.field_70163_u, item.field_70161_v));
    }

    public static ItemStack addStack(@Nonnull ItemStack stack, @Nonnull IBeeHousing housing, Vec3d fallback) {
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack remainder = EffectBase.tryAdd(stack, housing.getBeeInventory());
        if (remainder.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        TileEntity tileEntity = housing.getWorldObj().func_175625_s(housing.getCoordinates());
        if (tileEntity instanceof IBeeHousing && ((IBeeHousing)tileEntity).getBeeInventory() == housing.getBeeInventory()) {
            housing = (IBeeHousing)tileEntity;
        }
        if (!(housing instanceof TileEntity)) {
            return remainder;
        }
        TObjectIntHashMap entryMap = map.computeIfAbsent(housing, l -> new TObjectIntHashMap());
        InsertEntry insertEntry = new InsertEntry(ItemHandlerHelper.copyStackWithSize((ItemStack)remainder, (int)1), fallback, housing.getWorldObj().field_73011_w.getDimension());
        entryMap.adjustOrPutValue((Object)insertEntry, stack.func_190916_E(), stack.func_190916_E());
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (map.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<IBeeHousing, TObjectIntHashMap<InsertEntry>>> housingIterator = map.entrySet().iterator();
        while (housingIterator.hasNext()) {
            Map.Entry<IBeeHousing, TObjectIntHashMap<InsertEntry>> entry = housingIterator.next();
            IBeeHousing beeHousing = entry.getKey();
            if (!(beeHousing instanceof TileEntity) || ((TileEntity)beeHousing).func_145837_r()) {
                housingIterator.remove();
                continue;
            }
            TObjectIntHashMap<InsertEntry> list = entry.getValue();
            TObjectIntIterator stackIterator = list.iterator();
            while (stackIterator.hasNext()) {
                stackIterator.advance();
                InsertEntry key = (InsertEntry)stackIterator.key();
                ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)key.stack, (int)stackIterator.value());
                ItemStack remainder = EffectBase.tryAdd(stack, beeHousing.getBeeInventory());
                int count = remainder.func_190916_E();
                if (DimensionManager.getWorld((int)0).field_73012_v.nextInt(256) == 0) {
                    --count;
                }
                if (count <= 0) {
                    stackIterator.remove();
                    continue;
                }
                stackIterator.setValue(count);
            }
            if (!list.isEmpty()) continue;
            housingIterator.remove();
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(DelayedInsertionHelper.class);
    }

    static class InsertEntry {
        @Nonnull
        final ItemStack stack;
        @Nullable
        final Vec3d fallbackpos;
        final int dim;

        InsertEntry(@Nonnull ItemStack stack, @Nullable Vec3d fallbackpos, int dim) {
            this.stack = stack;
            this.fallbackpos = fallbackpos;
            this.dim = dim;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InsertEntry)) {
                return false;
            }
            InsertEntry that = (InsertEntry)o;
            return this.dim == that.dim && ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)that.stack) && (this.fallbackpos != null ? this.fallbackpos.equals((Object)that.fallbackpos) : that.fallbackpos == null);
        }

        public int hashCode() {
            int result = this.stack.func_77973_b().hashCode();
            result = 31 * result + this.stack.func_77960_j();
            result = 31 * result + (this.stack.func_77942_o() ? 1 : 0);
            result = 31 * result + (this.fallbackpos != null ? this.fallbackpos.hashCode() : 0);
            result = 31 * result + this.dim;
            return result;
        }
    }
}

