/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.helpers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class PrivateHelper {
    private static final Map<Class<?>, Class<?>> primitiveTypes = new HashMap(13);

    public static Field getField(@Nonnull Class clazz, String ... fields) {
        for (String fieldName : fields) {
            if (Stream.of(clazz.getDeclaredFields()).map(Field::getName).noneMatch(fieldName::equals)) continue;
            try {
                Field declaredField = clazz.getDeclaredField(fieldName);
                if (declaredField == null) continue;
                declaredField.setAccessible(true);
                return declaredField;
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        if (clazz == Object.class) {
            throw new RuntimeException("Unable to find fields: " + Stream.of(fields).collect(Collectors.joining(", ")));
        }
        return PrivateHelper.getField(clazz.getSuperclass(), fields);
    }

    public static Method getMethod(@Nonnull Class<?> clazz, Class<?>[] parameters, String ... methods) {
        for (String methodName : methods) {
            Method bestMatch = null;
            for (Method method : clazz.getDeclaredMethods()) {
                int i;
                Class<?>[] parameterTypes;
                if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != parameters.length) continue;
                boolean flag = true;
                for (i = 0; i < parameterTypes.length; ++i) {
                    if (parameters[i] == parameterTypes[i]) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    method.setAccessible(true);
                    return method;
                }
                flag = true;
                for (i = 0; i < parameterTypes.length; ++i) {
                    if (parameters[i] == parameterTypes[i] || primitiveTypes.get(parameters[i]) == parameterTypes[i]) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                bestMatch = method;
            }
            if (bestMatch == null) continue;
            bestMatch.setAccessible(true);
            return bestMatch;
        }
        if (clazz == Object.class) {
            throw new RuntimeException("Unable to find method: " + Stream.of(methods).collect(Collectors.joining(", ")));
        }
        return PrivateHelper.getMethod(clazz.getSuperclass(), parameters, methods);
    }

    static {
        primitiveTypes.put(Boolean.class, Boolean.TYPE);
        primitiveTypes.put(Byte.class, Byte.TYPE);
        primitiveTypes.put(Character.class, Character.TYPE);
        primitiveTypes.put(Double.class, Double.TYPE);
        primitiveTypes.put(Float.class, Float.TYPE);
        primitiveTypes.put(Integer.class, Integer.TYPE);
        primitiveTypes.put(Long.class, Long.TYPE);
        primitiveTypes.put(Short.class, Short.TYPE);
        primitiveTypes.put(Void.class, Void.TYPE);
    }
}

