/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.entity;

import com.google.common.collect.HashBiMap;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.entity.ChunkDataModuleManager;
import com.rwtema.careerbees.entity.StudentManager;
import com.rwtema.careerbees.entity.YenteBeeManager;
import com.rwtema.careerbees.networking.BeeNetworking;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.Validate;

public class EntityChunkData
extends Entity
implements IEntityAdditionalSpawnData {
    @Nonnull
    public static final HashBiMap<String, ChunkDataModuleManager> managers = HashBiMap.create();
    public Map<ChunkDataModuleManager, Object> objectHashMap = new HashMap<ChunkDataModuleManager, Object>();
    ChunkPos pos;
    private boolean dirty;

    public EntityChunkData(@Nonnull World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.func_184224_h(true);
        this.func_70105_a(0.0f, 0.0f);
        this.func_82142_c(true);
    }

    public EntityChunkData(@Nonnull World world, ChunkPos chunkPos) {
        this(world);
        this.pos = chunkPos;
        this.field_70169_q = this.field_70165_t = (double)((this.pos.field_77276_a << 4) + 8);
        this.field_70163_u = 512.0;
        this.field_70167_r = 512.0;
        this.field_70166_s = this.field_70161_v = (double)((this.pos.field_77275_b << 4) + 8);
    }

    public static void init() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("careerbees", "entitychunkdata"), EntityChunkData.class, (String)"entitychunkdata", (int)0, (Object)BeeMod.instance, (int)64, (int)Integer.MAX_VALUE, (boolean)false);
    }

    public static void markChunkDirty(@Nonnull Chunk chunk) {
        EntityChunkData dataEntity = EntityChunkData.getChunkDataEntity(chunk);
        if (dataEntity != null) {
            dataEntity.dirty = true;
        }
    }

    public static <T> T getChunkData(@Nonnull Chunk chunk, @Nonnull ChunkDataModuleManager<T> manager, boolean create) {
        EntityChunkData dataEntity = EntityChunkData.getChunkDataEntity(chunk);
        if (dataEntity == null) {
            if (create) {
                World world = chunk.func_177412_p();
                dataEntity = new EntityChunkData(world, new ChunkPos(chunk.field_76635_g, chunk.field_76647_h));
                T blank = manager.createBlank();
                dataEntity.objectHashMap.put(manager, blank);
                world.func_72838_d((Entity)dataEntity);
                return blank;
            }
            return manager.getCachedBlank();
        }
        Object o = dataEntity.objectHashMap.get(manager);
        if (o == null) {
            if (create) {
                T blank = manager.createBlank();
                dataEntity.objectHashMap.put(manager, blank);
                return blank;
            }
            return manager.getCachedBlank();
        }
        return (T)o;
    }

    @Nullable
    public static EntityChunkData getChunkDataEntity(@Nonnull Chunk chunk) {
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        for (int i = entityLists.length - 1; i >= 0; --i) {
            ClassInheritanceMultiMap entities = entityLists[i];
            if (entities.isEmpty()) continue;
            for (EntityChunkData entityChunkData : entities.func_180215_b(EntityChunkData.class)) {
                if (entityChunkData.field_70128_L) continue;
                return entityChunkData;
            }
        }
        return null;
    }

    public static void writeData(@Nonnull ByteBuf buffer, @Nonnull Map<ChunkDataModuleManager, Object> objectHashMap) {
        PacketBuffer packetBuffer = new PacketBuffer(buffer);
        packetBuffer.writeInt(objectHashMap.size());
        for (Map.Entry<ChunkDataModuleManager, Object> entry : objectHashMap.entrySet()) {
            ChunkDataModuleManager manager = entry.getKey();
            packetBuffer.func_180714_a((String)managers.inverse().get((Object)manager));
            manager.writeData(entry.getValue(), packetBuffer);
        }
    }

    public static void readSpawnData(@Nonnull ByteBuf additionalData, @Nonnull Map<ChunkDataModuleManager, Object> objectHashMap) {
        objectHashMap.clear();
        PacketBuffer buffer = new PacketBuffer(additionalData);
        int n = buffer.readInt();
        for (int i = 0; i < n; ++i) {
            ChunkDataModuleManager manager = (ChunkDataModuleManager)managers.get((Object)buffer.func_150789_c(64));
            Object blank = ((ChunkDataModuleManager)Validate.notNull((Object)manager)).createBlank();
            manager.readData(blank, buffer);
            objectHashMap.put(manager, blank);
        }
    }

    public int func_82145_z() {
        return Integer.MAX_VALUE;
    }

    public <T> boolean hasData(ChunkDataModuleManager<T> manager) {
        return this.objectHashMap.containsKey(manager);
    }

    @Nonnull
    public <T> T getData(ChunkDataModuleManager<T> manager) {
        return (T)this.objectHashMap.get(manager);
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected boolean func_184219_q(Entity passenger) {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_174814_R() {
        return true;
    }

    @Nullable
    public Entity func_184204_a(int dimensionIn) {
        return null;
    }

    protected void func_70081_e(int amount) {
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            Chunk chunkFromChunkCoords = this.field_70170_p.func_175726_f(new BlockPos((Entity)this));
            Iterator<Map.Entry<ChunkDataModuleManager, Object>> iterator = this.objectHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ChunkDataModuleManager, Object> entry = iterator.next();
                try {
                    entry.getKey().clientTick(chunkFromChunkCoords, entry.getValue());
                }
                catch (ClassCastException exception) {
                    exception.printStackTrace();
                    iterator.remove();
                }
            }
        } else {
            this.field_70169_q = this.field_70165_t = (double)((this.pos.field_77276_a << 4) + 8);
            this.field_70163_u = 512.0;
            this.field_70167_r = 512.0;
            this.field_70166_s = this.field_70161_v = (double)((this.pos.field_77275_b << 4) + 8);
            if (this.objectHashMap.isEmpty()) {
                this.func_70106_y();
            } else {
                Chunk chunkFromChunkCoords = this.field_70170_p.func_72964_e(this.pos.field_77276_a, this.pos.field_77275_b);
                Iterator<Map.Entry<ChunkDataModuleManager, Object>> iterator = this.objectHashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<ChunkDataModuleManager, Object> entry = iterator.next();
                    try {
                        if (!entry.getKey().onUpdate(chunkFromChunkCoords, entry.getValue())) continue;
                        iterator.remove();
                        this.dirty = true;
                    }
                    catch (ClassCastException exception) {
                        exception.printStackTrace();
                        iterator.remove();
                        this.dirty = true;
                    }
                }
                if (this.dirty) {
                    this.dirty = false;
                    if (this.field_70170_p instanceof WorldServer) {
                        EntityTracker tracker = ((WorldServer)this.field_70170_p).func_73039_n();
                        for (EntityPlayer player : tracker.getTrackingPlayers((Entity)this)) {
                            BeeNetworking.net.sendTo((IMessage)new PacketEntityChunkData(this.func_145782_y(), this.objectHashMap), (EntityPlayerMP)player);
                        }
                    }
                }
            }
        }
        super.func_70071_h_();
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.pos = new ChunkPos(compound.func_74762_e("chunk_x"), compound.func_74762_e("chunk_z"));
        this.objectHashMap.clear();
        NBTTagList data = compound.func_150295_c("xudata", 10);
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound tagAt = data.func_150305_b(i);
            ChunkDataModuleManager manager = (ChunkDataModuleManager)managers.get((Object)tagAt.func_74779_i("key"));
            if (manager == null) continue;
            Object o = manager.readFromNBT(tagAt);
            this.objectHashMap.put(manager, o);
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        compound.func_74768_a("chunk_x", this.pos.field_77276_a);
        compound.func_74768_a("chunk_z", this.pos.field_77275_b);
        NBTTagList data = new NBTTagList();
        Iterator<Map.Entry<ChunkDataModuleManager, Object>> iterator = this.objectHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ChunkDataModuleManager, Object> entry = iterator.next();
            String s = (String)managers.inverse().get((Object)entry.getKey());
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74778_a("key", s);
            try {
                entry.getKey().writeToNBT(nbtTagCompound, entry.getValue());
            }
            catch (ClassCastException exception) {
                iterator.remove();
                exception.printStackTrace();
                continue;
            }
            data.func_74742_a((NBTBase)nbtTagCompound);
        }
        compound.func_74782_a("xudata", (NBTBase)data);
    }

    public void writeSpawnData(@Nonnull ByteBuf buffer) {
        EntityChunkData.writeData(buffer, this.objectHashMap);
    }

    public void readSpawnData(@Nonnull ByteBuf additionalData) {
        EntityChunkData.readSpawnData(additionalData, this.objectHashMap);
    }

    static {
        managers.put((Object)"bee_student", (Object)new StudentManager());
        managers.put((Object)"bee_yente", (Object)new YenteBeeManager());
    }

    public static class PacketEntityChunkData
    extends BeeNetworking.MessageServerToClient {
        int entityId;
        Map<ChunkDataModuleManager, Object> objectHashMap;

        public PacketEntityChunkData() {
        }

        public PacketEntityChunkData(int entityId, Map<ChunkDataModuleManager, Object> objectHashMap) {
            this.entityId = entityId;
            this.objectHashMap = objectHashMap;
        }

        @Override
        protected void runClient(MessageContext ctx, EntityPlayer player) {
            Entity entityByID = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
            if (entityByID instanceof EntityChunkData) {
                ((EntityChunkData)entityByID).objectHashMap = this.objectHashMap;
            }
        }

        public void fromBytes(@Nonnull ByteBuf buf) {
            this.entityId = buf.readInt();
            this.objectHashMap = new HashMap<ChunkDataModuleManager, Object>();
            EntityChunkData.readSpawnData(buf, this.objectHashMap);
        }

        public void toBytes(@Nonnull ByteBuf buf) {
            buf.writeInt(this.entityId);
            EntityChunkData.writeData(buf, this.objectHashMap);
        }
    }
}

