/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.Streams;
import com.rwtema.careerbees.blocks.BlockFlowerPedastal;
import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.Filter;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import com.rwtema.careerbees.helpers.ParticleHelper;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class EffectItemModification
extends EffectBaseThrottled
implements ISpecialBeeEffect.SpecialEffectItem {
    final Filter filter = new Filter(this);

    public EffectItemModification(String name, float baseTicksBetweenProcessing) {
        this(name, false, false, baseTicksBetweenProcessing, 1.0f);
    }

    public EffectItemModification(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    @Override
    public boolean canAcceptItems() {
        return true;
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, @Nonnull World world, @Nonnull BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        Predicate<ItemStack> matcher = EffectItemModification.getFilter(housing, world, settings, EffectItemModification.getAABB(genome, housing), this.filter);
        List<TileFlowerPedastal> frameList = this.getPlantFrames(genome, housing, world, pos, settings);
        Collections.shuffle(frameList);
        for (TileFlowerPedastal plantFrame : frameList) {
            ItemStack itemStack;
            ItemStack stack = plantFrame.getStack();
            if (stack.func_190926_b() || !this.canHandleStack(stack, genome) || !matcher.test(stack) || (itemStack = this.modifyStack(genome, stack, housing)) == null) continue;
            plantFrame.setStack(itemStack);
            BlockFlowerPedastal.sendPulse(plantFrame, this.getParticleType(genome, plantFrame, stack, itemStack));
            if (this.shouldRelease(genome, plantFrame, stack, itemStack, housing)) {
                plantFrame.setShouldRelease();
            }
            return;
        }
    }

    @Override
    @Nullable
    public ItemStack handleStack(ItemStack stack, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        return this.acceptItemStack(stack) ? this.modifyStack(genome, stack, housing) : null;
    }

    @Nonnull
    protected List<TileFlowerPedastal> getPlantFrames(@Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing, @Nonnull World world, @Nonnull BlockPos pos, IEffectSettingsHolder settings) {
        Vec3d territory = EffectItemModification.getTerritory(genome, housing);
        int x_min = MathHelper.func_76128_c((double)((double)pos.func_177958_n() - territory.field_72450_a));
        int x_max = MathHelper.func_76143_f((double)((double)pos.func_177958_n() + territory.field_72450_a));
        int y_min = MathHelper.func_76128_c((double)((double)pos.func_177956_o() - territory.field_72448_b));
        int y_max = MathHelper.func_76143_f((double)((double)pos.func_177956_o() + territory.field_72448_b));
        int z_min = MathHelper.func_76128_c((double)((double)pos.func_177952_p() - territory.field_72449_c));
        int z_max = MathHelper.func_76143_f((double)((double)pos.func_177952_p() + territory.field_72449_c));
        Predicate<ItemStack> matcher = this.filter.getMatcher(settings);
        ArrayList<TileFlowerPedastal> frameList = new ArrayList<TileFlowerPedastal>();
        for (int chunk_x = x_min >> 4; chunk_x <= x_max >> 4; ++chunk_x) {
            for (int chunk_z = z_min >> 4; chunk_z <= z_max >> 4; ++chunk_z) {
                Chunk chunk = world.func_72964_e(chunk_x, chunk_z);
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    ItemStack stack;
                    TileFlowerPedastal plantFrame;
                    TileEntity tileEntity;
                    BlockPos key = (BlockPos)entry.getKey();
                    if (key.func_177958_n() < x_min || key.func_177958_n() > x_max || key.func_177956_o() < y_min || key.func_177956_o() > y_max || key.func_177952_p() < z_min || key.func_177952_p() > z_max || !((tileEntity = (TileEntity)entry.getValue()) instanceof TileFlowerPedastal) || !(plantFrame = (TileFlowerPedastal)tileEntity).accepts(genome) || (stack = plantFrame.getStack()).func_190926_b() || !this.canHandleStack(stack, genome) || !matcher.test(stack)) continue;
                    frameList.add(plantFrame);
                }
            }
        }
        return frameList;
    }

    public boolean handleBlock(World world, BlockPos pos, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        return false;
    }

    public boolean handleEntityLiving(EntityLivingBase livingBase, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        return false;
    }

    @Nonnull
    protected BlockFlowerPedastal.ParticleType getParticleType(IBeeGenome genome, TileFlowerPedastal plantFrame, ItemStack stack, ItemStack itemStack) {
        return BlockFlowerPedastal.ParticleType.YELLOW;
    }

    @Nullable
    public abstract ItemStack modifyStack(IBeeGenome var1, ItemStack var2, @Nullable IBeeHousing var3);

    public boolean shouldRelease(IBeeGenome genome, TileFlowerPedastal frame, ItemStack oldStack, @Nonnull ItemStack newStack, IBeeHousing housing) {
        if (!this.acceptItemStack(newStack)) {
            return true;
        }
        ItemStack stack = this.modifyStack(genome, newStack.func_77946_l(), housing);
        return stack == null || stack.func_77969_a(newStack) && Objects.equals(stack.func_77978_p(), newStack.func_77978_p());
    }

    @Override
    public abstract boolean acceptItemStack(ItemStack var1);

    @Override
    public boolean canHandleStack(ItemStack stack, @Nonnull IBeeGenome genome) {
        return this.acceptItemStack(stack);
    }

    @Override
    @Nonnull
    public IEffectData doFX(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing) {
        BlockPos pos;
        World world = housing.getWorldObj();
        List<TileFlowerPedastal> frameList = this.getPlantFrames(genome, housing, world, pos = housing.getCoordinates(), IEffectSettingsHolder.DEFAULT_INSTANCE);
        if (frameList.isEmpty()) {
            return super.doFX(genome, storedData, housing);
        }
        ParticleHelper.BEE_HIVE_FX.addBeeHiveFX(housing, genome, Streams.concat((Stream[])new Stream[]{frameList.stream().map(TileEntity::func_174877_v), housing.getBeekeepingLogic().getFlowerPositions().stream()}).collect(Collectors.toList()));
        return storedData;
    }
}

