/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.effects.BaseEffectDataMap;
import com.rwtema.careerbees.effects.settings.Filter;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import com.rwtema.careerbees.effects.settings.Setting;
import com.rwtema.careerbees.helpers.ParticleHelper;
import com.rwtema.careerbees.helpers.RandomHelper;
import com.rwtema.careerbees.helpers.StringHelper;
import com.rwtema.careerbees.items.ItemEternalFrame;
import com.rwtema.careerbees.lang.Lang;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IEffectData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public abstract class EffectBase
implements IAlleleBeeEffect {
    public static final HashMap<IAlleleBeeSpecies, EffectBase> registeredEffectSpecies = new HashMap();
    protected static final WeakHashMap<IBeeHousing, Iterable<BlockPos>> adjacentPosCache = new WeakHashMap();
    static int n = 0;
    @Nonnull
    private final String uuid;
    @Nonnull
    private final String rawname;
    @Nonnull
    private final String unlocalizedName;
    private final boolean isDominant;
    private final boolean isCombinable;
    @Nonnull
    public Set<IAlleleBeeSpecies> validSpecies = ImmutableSet.of();
    public final List<Setting<?, ?>> settings = new ArrayList();

    public EffectBase(String rawname) {
        this(rawname, false, false);
    }

    public EffectBase(@Nonnull String rawname, boolean isDominant, boolean isCombinable) {
        this.rawname = rawname;
        this.unlocalizedName = "careerbees.allele.effect." + rawname;
        if (BeeMod.deobf_folder) {
            String capName = StringHelper.capFirstMulti(rawname);
            Lang.translate(this.unlocalizedName, capName);
            Lang.translate(this.unlocalizedName + ".desc", capName + " Description");
        }
        this.uuid = "careerbees.effect." + rawname;
        this.isDominant = isDominant;
        this.isCombinable = isCombinable;
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{EnumBeeChromosome.EFFECT});
    }

    public static float getSpeed(@Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        ItemEternalFrame.checkProduction.set(true);
        float speed = genome.getSpeed() * EffectBase.getModifier(genome, housing, (m, g) -> Float.valueOf(m.getProductionModifier(g, 1.0f)));
        ItemEternalFrame.checkProduction.set(false);
        if ("forestry.apiculture.tiles.TileBeeHouse".equals(housing.getClass().getName())) {
            speed *= 0.4f;
        }
        return speed;
    }

    public static float getModifier(IBeeGenome genome, @Nonnull IBeeHousing housing, @Nonnull BiFunction<IBeeModifier, IBeeGenome, Float> function) {
        World world = housing.getWorldObj();
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        IBeeModifier beeHousingModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        IBeeModifier beeModeModifier = mode.getBeeModifier();
        return function.apply(beeHousingModifier, genome).floatValue() * function.apply(beeModeModifier, genome).floatValue();
    }

    public static AxisAlignedBB getAABB(@Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        Vec3d territory = EffectBase.getTerritory(genome, housing);
        return new AxisAlignedBB(housing.getCoordinates()).func_72314_b(territory.field_72450_a, territory.field_72448_b, territory.field_72449_c);
    }

    @Nonnull
    public static Vec3d getTerritory(@Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        Vec3i territory = genome.getTerritory();
        float modifier = EffectBase.getModifier(genome, housing, (iBeeModifier, genome1) -> Float.valueOf(iBeeModifier.getTerritoryModifier(genome1, 1.0f)));
        return new Vec3d((double)((float)territory.func_177958_n() * modifier), (double)((float)territory.func_177956_o() * modifier), (double)((float)territory.func_177952_p() * modifier));
    }

    public static ItemStack tryAdd(@Nonnull ItemStack stack, @Nonnull IBeeHousingInventory inventory) {
        ItemStack copy;
        int amt;
        int n;
        if (stack.func_190926_b() || inventory.addProduct(stack, true)) {
            return ItemStack.field_190927_a;
        }
        for (amt = stack.func_190916_E(); amt > 0 && (n = Integer.highestOneBit(amt)) > 0 && inventory.addProduct(copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)n), true); amt -= n) {
        }
        if (amt == stack.func_190916_E()) {
            return stack;
        }
        if (amt == 0) {
            return ItemStack.field_190927_a;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amt);
    }

    @SubscribeEvent
    public static void tickCleanup(@Nonnull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++n > 400) {
            adjacentPosCache.clear();
            n = 0;
        }
    }

    public static int getRand(int a, int b, @Nonnull Random random) {
        if (a == b) {
            return a;
        }
        if (a < b) {
            return a + random.nextInt(b - a);
        }
        return b + random.nextInt(a - b);
    }

    public IEffectSettingsHolder getSettings(@Nonnull IBeeHousing housing) {
        if (!this.settings.isEmpty()) {
            for (IBeeModifier iBeeModifier : housing.getBeeModifiers()) {
                if (!(iBeeModifier instanceof IEffectSettingsHolder)) continue;
                return (IEffectSettingsHolder)iBeeModifier;
            }
        }
        return IEffectSettingsHolder.DEFAULT_INSTANCE;
    }

    @Nonnull
    public IEffectData doEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing) {
        if (this.isValidSpecies(genome) && !housing.getWorldObj().field_72995_K) {
            return this.doEffectBase(genome, storedData, housing, this.getSettings(housing));
        }
        return storedData;
    }

    @Nonnull
    public abstract IEffectData doEffectBase(@Nonnull IBeeGenome var1, @Nonnull IEffectData var2, @Nonnull IBeeHousing var3, IEffectSettingsHolder var4);

    @Nonnull
    public IEffectData doFX(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing) {
        IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
        List flowerPositions = beekeepingLogic.getFlowerPositions();
        ParticleHelper.BEE_HIVE_FX.addBeeHiveFX(housing, genome, flowerPositions);
        return storedData;
    }

    public boolean isCombinable() {
        return this.isCombinable;
    }

    @Nonnull
    public IEffectData validateStorage(@Nullable IEffectData storedData) {
        if (storedData != null) {
            return storedData;
        }
        return BaseEffectDataMap.None.INSTANCE;
    }

    @Nonnull
    public String getUID() {
        return this.uuid;
    }

    public boolean isDominant() {
        return this.isDominant;
    }

    @Nonnull
    public String getName() {
        return this.rawname;
    }

    @Nonnull
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Nonnull
    public String getAlleleName() {
        return I18n.func_74838_a((String)this.getUnlocalizedName());
    }

    public void addSpecies(@Nonnull IAlleleBeeSpecies species) {
        this.validSpecies = ImmutableSet.builder().addAll(this.validSpecies).add((Object)species).build();
        if (registeredEffectSpecies.put(species, this) != null) {
            throw new IllegalStateException();
        }
    }

    public boolean isValidSpecies(@Nonnull IBeeGenome genome) {
        return this.isValidSpecies(genome.getPrimary()) || this.isValidSpecies(genome.getSecondary());
    }

    public boolean isValidSpecies(IAlleleBeeSpecies species) {
        return this.validSpecies.contains(species);
    }

    public boolean acceptItemStack(ItemStack stack) {
        return false;
    }

    public boolean canAcceptItems() {
        return false;
    }

    public <V, NBT extends NBTBase> void addSetting(Setting vnbtSetting) {
        this.settings.add(vnbtSetting);
    }

    public <T extends TileEntity> List<T> getTiles(@Nonnull World world, @Nonnull Class<T> clazz, @Nonnull AxisAlignedBB bounds) {
        int x_min = MathHelper.func_76128_c((double)bounds.field_72340_a);
        int y_min = MathHelper.func_76128_c((double)bounds.field_72338_b);
        int z_min = MathHelper.func_76128_c((double)bounds.field_72339_c);
        int x_max = MathHelper.func_76143_f((double)bounds.field_72336_d);
        int y_max = MathHelper.func_76143_f((double)bounds.field_72337_e);
        int z_max = MathHelper.func_76143_f((double)bounds.field_72334_f);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int chunk_x = x_min >> 4; chunk_x <= x_max >> 4; ++chunk_x) {
            for (int chunk_z = z_min >> 4; chunk_z <= z_max >> 4; ++chunk_z) {
                Chunk chunk = world.func_72964_e(chunk_x, chunk_z);
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    TileEntity tileEntity;
                    BlockPos key = (BlockPos)entry.getKey();
                    if (key.func_177958_n() < x_min || key.func_177958_n() > x_max || key.func_177956_o() < y_min || key.func_177956_o() > y_max || key.func_177952_p() < z_min || key.func_177952_p() > z_max || !clazz.isInstance(tileEntity = (TileEntity)entry.getValue())) continue;
                    builder.add(clazz.cast(tileEntity));
                }
            }
        }
        return builder.build();
    }

    protected Iterable<BlockPos> getAdjacentTiles(@Nonnull IBeeHousing h) {
        BlockPos pos = h.getCoordinates();
        World world = h.getWorldObj();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IBeeHousing)) {
            return Stream.concat(Stream.of(pos), Stream.of(RandomHelper.getPermutation()).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)))::iterator;
        }
        return adjacentPosCache.computeIfAbsent(h, this::getBlockPos);
    }

    @Nonnull
    private Iterable<BlockPos> getBlockPos(@Nonnull IBeeHousing h) {
        BlockPos blockPos;
        World world = h.getWorldObj();
        Random rand = world.field_73012_v;
        BlockPos pos = h.getCoordinates();
        IBeeHousingInventory beeInventory = h.getBeeInventory();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> adjToHousing = new ArrayList<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        Arrays.stream(RandomHelper.getPermutation(rand)).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).forEach(toCheck::add);
        while ((blockPos = (BlockPos)toCheck.poll()) != null) {
            TileEntity te = world.func_175625_s(blockPos);
            if (te instanceof IBeeHousing && ((IBeeHousing)te).getBeeInventory() == beeInventory) {
                for (EnumFacing facing : RandomHelper.getPermutation(rand)) {
                    BlockPos newpos = blockPos.func_177972_a(facing);
                    if (!checked.add(newpos)) continue;
                    toCheck.add(newpos);
                }
                continue;
            }
            adjToHousing.add(blockPos);
        }
        return adjToHousing;
    }

    public <C> List<C> getAdjacentCapabilities(@Nonnull IBeeHousing housing, @Nonnull Capability<C> capability) {
        return this.getAdjacentCapabilities(housing, capability, t -> true);
    }

    public <C> List<C> getAdjacentCapabilities(@Nonnull IBeeHousing housing, @Nonnull Capability<C> capability, Predicate<TileEntity> tileEntityFilter) {
        return Streams.stream(this.getAdjacentTiles(housing)).map(arg_0 -> ((World)housing.getWorldObj()).func_175625_s(arg_0)).filter(Objects::nonNull).filter(tileEntityFilter).map(t -> t.getCapability(capability, null)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public float getCooldown(IBeeGenome genome, Random random) {
        return 0.0f;
    }

    @Nonnull
    public static Predicate<ItemStack> getFilter(@Nonnull IBeeHousing housing, @Nonnull World world, @Nonnull IEffectSettingsHolder settings, AxisAlignedBB aabb, Filter filter) {
        Predicate<ItemStack> matcher = filter.getMatcher(settings);
        if (matcher == Filter.DEFAULT_MATCHER) {
            for (EntityItemFrame frame : world.func_72872_a(EntityItemFrame.class, aabb)) {
                BlockPos hangingPosition;
                TileEntity entity;
                ItemStack stack = frame.func_82335_i();
                if (stack.func_190926_b() || !((entity = world.func_175625_s(hangingPosition = frame.func_174857_n().func_177972_a(frame.func_174811_aO().func_176734_d()))) instanceof IBeeHousing) || ((IBeeHousing)entity).getBeeInventory() != housing.getBeeInventory()) continue;
                if (matcher == Filter.DEFAULT_MATCHER) {
                    matcher = inStack -> OreDictionary.itemMatches((ItemStack)stack, (ItemStack)inStack, (boolean)false);
                    continue;
                }
                Predicate<ItemStack> prev = matcher;
                matcher = inStack -> inStack != null && (prev.test((ItemStack)inStack) || OreDictionary.itemMatches((ItemStack)stack, (ItemStack)inStack, (boolean)false));
            }
        }
        return matcher;
    }

    static {
        MinecraftForge.EVENT_BUS.register(EffectBase.class);
    }
}

