/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectWorldInteraction;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EffectAssassin
extends EffectWorldInteraction {
    public static final EffectAssassin INSTANCE = new EffectAssassin("assassin", 10.0f);

    public EffectAssassin(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    public EffectAssassin(String name, int baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    public EffectAssassin(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    @Override
    public boolean canHandleBlock(World world, BlockPos pos, @Nonnull IBeeGenome genome, @Nullable EnumFacing sideHit) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IBeeHousing) {
            ItemStack queen = ((IBeeHousing)tileEntity).getBeeInventory().getQueen();
            if (queen.func_190926_b() || BeeManager.beeRoot.getType(queen) != EnumBeeType.QUEEN) {
                return false;
            }
            IBee member = BeeManager.beeRoot.getMember(queen);
            if (member == null) {
                return false;
            }
            IBeeGenome memberGenome = member.getGenome();
            return memberGenome.getPrimary() != genome.getPrimary();
        }
        return false;
    }

    @Override
    protected boolean performPosEffect(World world, BlockPos blockPos, IBlockState state, IBeeGenome genome, IBeeHousing housing) {
        IBeeHousing house = (IBeeHousing)world.func_175625_s(blockPos);
        if (house == null) {
            return false;
        }
        ItemStack queenStack = house.getBeeInventory().getQueen();
        IBee queen = BeeManager.beeRoot.getMember(queenStack);
        if (queen == null || queenStack.func_190926_b() || !queenStack.func_77942_o()) {
            return false;
        }
        queen.setHealth(0);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        queen.writeToNBT(nbttagcompound);
        queenStack.func_77982_d(nbttagcompound);
        housing.getBeeInventory().setQueen(queenStack);
        house.getBeekeepingLogic().canWork();
        return true;
    }
}

