/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanintegrations.modules.patchouli.processor;

import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktables;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

public class WorktableProcessor
implements IComponentProcessor {
    protected String tableName;
    protected IArtisanRecipe recipe;

    public void setup(IVariableProvider<String> variables) {
        String recipe = (String)variables.get("recipe");
        this.tableName = recipe.split(":")[0];
        this.recipe = ArtisanAPI.getRecipe((String)recipe);
        if (this.recipe == null) {
            throw new IllegalArgumentException("Can't find Artisan Worktables recipe with name " + recipe);
        }
    }

    public String process(String key) {
        if (this.recipe != null) {
            if ("table_image".equals(key)) {
                return this.getTableBackgroundImage(this.tableName);
            }
            if (key.startsWith("item")) {
                int recipeIndex;
                int tableIndex = Integer.parseInt(key.substring(4)) - 1;
                List ingredientList = this.recipe.getIngredientList();
                if (this.recipe.isShaped()) {
                    int tableWidth = this.getTableTier() == EnumTier.WORKSHOP ? 5 : 3;
                    int tableHeight = this.getTableTier() == EnumTier.WORKSHOP ? 5 : 3;
                    int col = tableIndex % tableWidth;
                    int recipeWidth = this.recipe.getWidth();
                    int row = tableIndex / tableHeight;
                    int recipeHeight = this.recipe.getHeight();
                    if (col >= recipeWidth || row >= recipeHeight) {
                        return "";
                    }
                    recipeIndex = tableIndex - row * (tableWidth - recipeWidth);
                } else {
                    if (tableIndex >= ingredientList.size()) {
                        return "";
                    }
                    recipeIndex = tableIndex;
                }
                Ingredient ingredient = ((IArtisanIngredient)ingredientList.get(recipeIndex)).toIngredient();
                ItemStack[] stacks = ingredient.func_193365_a();
                ItemStack stack = stacks.length == 0 ? ItemStack.field_190927_a : stacks[0];
                return ItemStackUtil.serializeStack((ItemStack)stack);
            }
            if (key.startsWith("extra_item_chance")) {
                int index = Integer.parseInt(key.substring(17)) - 1;
                switch (index) {
                    case 0: {
                        return String.valueOf((int)(this.recipe.getSecondaryOutputChance() * 100.0f));
                    }
                    case 1: {
                        return String.valueOf((int)(this.recipe.getTertiaryOutputChance() * 100.0f));
                    }
                    case 2: {
                        return String.valueOf((int)(this.recipe.getQuaternaryOutputChance() * 100.0f));
                    }
                }
                return ItemStackUtil.serializeStack((ItemStack)ItemStack.field_190927_a);
            }
            if (key.startsWith("extra_item")) {
                int index = Integer.parseInt(key.substring(10)) - 1;
                switch (index) {
                    case 0: {
                        IArtisanItemStack secondaryOutput = this.recipe.getSecondaryOutput();
                        return secondaryOutput.isEmpty() ? "" : ItemStackUtil.serializeStack((ItemStack)secondaryOutput.toItemStack());
                    }
                    case 1: {
                        IArtisanItemStack tertiaryOutput = this.recipe.getTertiaryOutput();
                        return tertiaryOutput.isEmpty() ? "" : ItemStackUtil.serializeStack((ItemStack)tertiaryOutput.toItemStack());
                    }
                    case 2: {
                        IArtisanItemStack quaternaryOutput = this.recipe.getQuaternaryOutput();
                        return quaternaryOutput.isEmpty() ? "" : ItemStackUtil.serializeStack((ItemStack)quaternaryOutput.toItemStack());
                    }
                }
                return "";
            }
            if ("output".equals(key)) {
                ItemStack[] itemStacks = (ItemStack[])this.recipe.getOutputWeightPairList().stream().map(OutputWeightPair::getOutput).map(IArtisanItemStack::toItemStack).toArray(ItemStack[]::new);
                Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])itemStacks);
                return ItemStackUtil.serializeIngredient((Ingredient)ingredient);
            }
            if (key.startsWith("tool_damage")) {
                int index = Integer.parseInt(key.substring(11)) - 1;
                return String.valueOf(this.recipe.getToolDamage(index));
            }
            if (key.startsWith("tool")) {
                int index = Integer.parseInt(key.substring(4)) - 1;
                IArtisanItemStack[] tools = this.recipe.getTools(index);
                if (tools.length > 0) {
                    ItemStack[] itemStacks = (ItemStack[])Arrays.stream(tools).map(IArtisanItemStack::toItemStack).toArray(ItemStack[]::new);
                    Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])itemStacks);
                    return ItemStackUtil.serializeIngredient((Ingredient)ingredient);
                }
                return "";
            }
            if ("input_fluid".equals(key)) {
                FluidStack fluidIngredient = this.recipe.getFluidIngredient();
                return fluidIngredient == null ? "" : fluidIngredient.getFluid().getName();
            }
            if ("input_fluid_name".equals(key)) {
                FluidStack fluidIngredient = this.recipe.getFluidIngredient();
                return fluidIngredient == null ? "" : fluidIngredient.getLocalizedName();
            }
            if ("input_fluid_amount".equals(key)) {
                FluidStack fluidIngredient = this.recipe.getFluidIngredient();
                return fluidIngredient == null ? "" : String.valueOf(fluidIngredient.amount);
            }
            if ("table_item".equals(key)) {
                EnumType type = EnumType.fromName((String)this.tableName);
                Item item = this.getTableItem();
                return item == null ? "" : ItemStackUtil.serializeStack((ItemStack)new ItemStack(item, 1, type.getMeta()));
            }
        }
        return null;
    }

    protected Item getTableItem() {
        return Item.func_150898_a((Block)ModuleWorktables.Blocks.WORKTABLE);
    }

    protected String getTableBackgroundImage(String tableName) {
        return "artisanworktables:textures/gui/worktable_" + tableName + ".png";
    }

    protected EnumTier getTableTier() {
        return EnumTier.WORKTABLE;
    }
}

