/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanintegrations.modules.gamestages.requirement;

import com.codetaylor.mc.artisanintegrations.modules.gamestages.requirement.GameStagesRequirement;
import com.codetaylor.mc.artisanintegrations.modules.gamestages.requirement.GameStagesRequirementContext;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class GameStagesRequirementBuilder
implements IRequirementBuilder<GameStagesRequirementContext, GameStagesRequirement> {
    private Set<String> excludeStages = Collections.emptySet();
    private Set<String> requireOneStage = Collections.emptySet();
    private Set<String> requireAllStages = Collections.emptySet();

    @Nonnull
    public String getRequirementId() {
        return "gamestages";
    }

    @Nonnull
    public ResourceLocation getResourceLocation() {
        return GameStagesRequirement.LOCATION;
    }

    public GameStagesRequirementBuilder allOf(String ... requireAllStages) {
        this.requireAllStages = new HashSet<String>();
        for (String stage : requireAllStages) {
            this.requireAllStages.add(stage.toLowerCase());
        }
        return this;
    }

    public GameStagesRequirementBuilder anyOf(String ... requireOneStage) {
        this.requireOneStage = new HashSet<String>();
        for (String stage : requireOneStage) {
            this.requireOneStage.add(stage.toLowerCase());
        }
        return this;
    }

    public GameStagesRequirementBuilder exclude(String ... excludeStages) {
        this.excludeStages = new HashSet<String>();
        for (String stage : excludeStages) {
            this.excludeStages.add(stage.toLowerCase());
        }
        return this;
    }

    public GameStagesRequirement create() {
        return new GameStagesRequirement(this.requireAllStages, this.requireOneStage, this.excludeStages);
    }
}

