/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanintegrations.modules.ftgu.requirement;

import com.codetaylor.mc.artisanintegrations.modules.ftgu.requirement.FTGURequirement;
import com.codetaylor.mc.artisanintegrations.modules.ftgu.requirement.FTGURequirementContext;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class FTGURequirementBuilder
implements IRequirementBuilder<FTGURequirementContext, FTGURequirement> {
    private Set<String> exclude = Collections.emptySet();
    private Set<String> requireOne = Collections.emptySet();
    private Set<String> requireAll = Collections.emptySet();

    @Nonnull
    public String getRequirementId() {
        return "ftgumod";
    }

    @Nonnull
    public ResourceLocation getResourceLocation() {
        return FTGURequirement.LOCATION;
    }

    public FTGURequirementBuilder allOf(String ... requireAll) {
        this.requireAll = new HashSet<String>();
        for (String technology : requireAll) {
            this.requireAll.add(technology.toLowerCase());
        }
        return this;
    }

    public FTGURequirementBuilder anyOf(String ... requireOne) {
        this.requireOne = new HashSet<String>();
        for (String technology : requireOne) {
            this.requireOne.add(technology.toLowerCase());
        }
        return this;
    }

    public FTGURequirementBuilder exclude(String ... exclude) {
        this.exclude = new HashSet<String>();
        for (String technology : exclude) {
            this.exclude.add(technology.toLowerCase());
        }
        return this;
    }

    public FTGURequirement create() {
        return new FTGURequirement(this.requireAll, this.requireOne, this.exclude);
    }
}

