/*
 * Decompiled with CFR 0.152.
 */
package cofh.shade.com.typesafe.config.impl;

import cofh.shade.com.typesafe.config.ConfigOrigin;
import cofh.shade.com.typesafe.config.ConfigParseOptions;
import cofh.shade.com.typesafe.config.ConfigParseable;
import cofh.shade.com.typesafe.config.ConfigSyntax;
import cofh.shade.com.typesafe.config.impl.AbstractConfigValue;
import cofh.shade.com.typesafe.config.impl.CoFHWorldParser;
import cofh.shade.com.typesafe.config.impl.ConfigImpl;
import cofh.shade.com.typesafe.config.impl.Parseable;
import cofh.shade.com.typesafe.config.impl.PropertiesParser;
import cofh.shade.com.typesafe.config.impl.SimpleConfigOrigin;
import cofh.shade.com.typesafe.config.impl.Token;
import cofh.shade.com.typesafe.config.impl.Tokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import javax.annotation.Nullable;

public class CoFHOrderedParsableFile
extends Parseable {
    private final File input;

    public CoFHOrderedParsableFile(File input, ConfigParseOptions options) {
        this.input = input;
        this.postConstruct(options);
    }

    @Override
    protected Reader reader() throws IOException {
        if (ConfigImpl.traceLoadsEnabled()) {
            CoFHOrderedParsableFile.trace("Loading config from a file: " + this.input);
        }
        FileInputStream stream = new FileInputStream(this.input);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
        return new BufferedReader(reader);
    }

    @Override
    ConfigSyntax guessSyntax() {
        return ConfigSyntax.CONF;
    }

    @Override
    @Nullable
    ConfigParseable relativeTo(String filename) {
        File sibling = new File(filename).isAbsolute() ? new File(filename) : CoFHOrderedParsableFile.relativeTo(this.input, filename);
        if (sibling == null) {
            return null;
        }
        if (sibling.exists()) {
            return new CoFHOrderedParsableFile(sibling, this.options().setOriginDescription(null));
        }
        return super.relativeTo(filename);
    }

    @Override
    protected ConfigOrigin createOrigin() {
        return SimpleConfigOrigin.newFile(this.input.getPath());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.input.getPath() + ")";
    }

    @Override
    protected AbstractConfigValue rawParseValue(Reader reader, ConfigOrigin origin, ConfigParseOptions finalOptions) throws IOException {
        if (finalOptions.getSyntax() == ConfigSyntax.PROPERTIES) {
            return PropertiesParser.parse(reader, origin);
        }
        Iterator<Token> tokens = Tokenizer.tokenize(origin, reader, finalOptions.getSyntax());
        return CoFHWorldParser.parse(tokens, origin, finalOptions, this.includeContext());
    }
}

