/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.distribution;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.util.Utils;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.distribution.Distribution;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.Fluid;

public class DistributionUnderfluid
extends Distribution {
    private final boolean water;
    private final WorldGenerator worldGen;
    private final INumberProvider count;
    private final List<WeightedBlock> matList;
    private final String[] fluidList;

    public DistributionUnderfluid(String name, WorldGenerator worldGen, List<WeightedBlock> matList, INumberProvider count, boolean regen) {
        super(name, regen);
        this.worldGen = worldGen;
        this.count = count;
        this.matList = matList;
        this.water = true;
        this.fluidList = null;
    }

    public DistributionUnderfluid(String name, WorldGenerator worldGen, List<WeightedBlock> matList, String[] fluidList, INumberProvider count, boolean regen) {
        super(name, regen);
        this.worldGen = worldGen;
        this.count = count;
        this.matList = matList;
        this.water = false;
        this.fluidList = fluidList;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = this.count.intValue(world, random, new INumberProvider.DataHolder(pos));
        this.worldGen.func_175904_e();
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int z;
            int x = blockX + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            int y = Utils.getSurfaceBlockY(world, x, z);
            block1: do {
                Fluid fluid;
                IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
                if (this.water ? state.func_185904_a() == Material.field_151586_h || world.func_180495_p(new BlockPos(x, y + 1, z)).func_185904_a() != Material.field_151586_h : (fluid = Utils.lookupFluidForBlock(state.func_177230_c())) != null && Arrays.binarySearch(this.fluidList, fluid.getName()) >= 0 || (fluid = Utils.lookupFluidForBlock(world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c())) == null || Arrays.binarySearch(this.fluidList, fluid.getName()) < 0) continue;
                for (WeightedBlock mat : this.matList) {
                    if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, new BlockPos(x, y, z), (Predicate)BlockMatcher.func_177642_a((Block)mat.block))) continue;
                    break block1;
                }
            } while (y-- > 1);
            if (y <= 0) continue;
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }
}

