/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.generator;

import cofh.cofhworld.data.PlaneShape;
import cofh.cofhworld.parser.IGeneratorParser;
import cofh.cofhworld.parser.variables.NumberData;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.generator.WorldGenMinablePlate;
import cofh.shade.com.typesafe.config.Config;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class GenParserPlate
implements IGeneratorParser {
    private static String[] FIELDS = new String[]{"block", "radius"};

    @Override
    public String[] getRequiredFields() {
        return FIELDS;
    }

    @Override
    @Nonnull
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedBlock> resList, List<WeightedBlock> matList) throws IGeneratorParser.InvalidGeneratorException {
        int clusterSize = genObject.getInt("radius");
        if (clusterSize <= 0) {
            log.warn("Invalid `radius` for generator '{}'", (Object)name);
            throw new IGeneratorParser.InvalidGeneratorException("Invalid `radius`", genObject.getValue("radius").origin());
        }
        WorldGenMinablePlate r = new WorldGenMinablePlate(resList, MathHelper.func_76125_a((int)clusterSize, (int)0, (int)32), matList);
        if (genObject.hasPath("height")) {
            r.setHeight(NumberData.parseNumberValue(genObject.getValue("height"), 0, 64));
        }
        if (genObject.hasPath("slim")) {
            r.setSlim(genObject.getBoolean("slim"));
        }
        if (genObject.hasPath("shape")) {
            r.setShape(PlaneShape.valueOf(genObject.getString("shape")));
        }
        return r;
    }
}

