/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.distribution;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.parser.distribution.base.AbstractDistParser;
import cofh.cofhworld.parser.variables.BlockData;
import cofh.cofhworld.parser.variables.StringData;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.util.random.WeightedString;
import cofh.cofhworld.world.distribution.Distribution;
import cofh.cofhworld.world.distribution.DistributionUnderfluid;
import cofh.shade.com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Logger;

public class DistParserUnderfluid
extends AbstractDistParser {
    private boolean isUnderwater;

    public DistParserUnderfluid(boolean water) {
        this.isUnderwater = water;
    }

    @Override
    protected List<WeightedBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedBlock(Blocks.field_150346_d, -1), new WeightedBlock((Block)Blocks.field_150349_c, -1));
    }

    @Override
    @Nonnull
    protected Distribution getFeature(String featureName, Config genObject, WorldGenerator gen, INumberProvider numClusters, boolean retrogen, Logger log) {
        boolean water = true;
        HashSet<String> fluidList = new HashSet<String>();
        if (genObject.hasPath("fluid")) {
            ArrayList<WeightedString> list = new ArrayList<WeightedString>();
            if (StringData.parseStringList(genObject.getValue("fluid"), list)) {
                water = false;
                for (WeightedString str : list) {
                    Fluid fluid = FluidRegistry.getFluid((String)str.value);
                    if (fluid == null) continue;
                    fluidList.add(fluid.getName());
                }
            }
        }
        List<WeightedBlock> matList = this.defaultMaterial;
        if (genObject.hasPath("material")) {
            matList = new ArrayList<WeightedBlock>();
            if (!BlockData.parseBlockList(genObject.getValue("material"), matList, false)) {
                log.warn("Invalid material list! Using default list.");
                matList = this.defaultMaterial;
            }
        }
        if (water) {
            return new DistributionUnderfluid(featureName, gen, matList, numClusters, retrogen);
        }
        return new DistributionUnderfluid(featureName, gen, matList, fluidList.toArray(new String[0]), numClusters, retrogen);
    }

    @Override
    protected String getDefaultGenerator() {
        return this.isUnderwater ? "plate" : super.getDefaultGenerator();
    }
}

