/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.init;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.init.WorldHandler;
import cofh.cofhworld.init.WorldProps;
import cofh.cofhworld.parser.DistributionData;
import cofh.cofhworld.parser.IDistributionParser;
import cofh.cofhworld.parser.IGeneratorParser;
import cofh.cofhworld.world.IFeatureGenerator;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigException;
import cofh.shade.com.typesafe.config.ConfigIncludeContext;
import cofh.shade.com.typesafe.config.ConfigIncluder;
import cofh.shade.com.typesafe.config.ConfigIncluderClasspath;
import cofh.shade.com.typesafe.config.ConfigIncluderFile;
import cofh.shade.com.typesafe.config.ConfigIncluderURL;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigParseOptions;
import cofh.shade.com.typesafe.config.ConfigResolveOptions;
import cofh.shade.com.typesafe.config.ConfigSyntax;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import cofh.shade.com.typesafe.config.impl.CoFHOrderedParsableFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

public class FeatureParser {
    private static HashMap<String, IDistributionParser> distributionHandlers = new HashMap();
    private static HashMap<String, IGeneratorParser> generatorHandlers = new HashMap();
    public static ArrayList<IFeatureGenerator> parsedFeatures = new ArrayList();

    private FeatureParser() {
    }

    public static IDistributionParser getDistribution(String distribution) {
        return distributionHandlers.get(distribution);
    }

    public static IGeneratorParser getGenerator(String generator) {
        return generatorHandlers.get(generator);
    }

    public static boolean registerTemplate(String template, IDistributionParser handler) {
        if (!distributionHandlers.containsKey(template)) {
            distributionHandlers.put(template, handler);
            return true;
        }
        CoFHWorld.log.error("Attempted to register duplicate template '{}'!", (Object)template);
        return false;
    }

    public static boolean registerGenerator(String generator, IGeneratorParser handler) {
        if (!generatorHandlers.containsKey(generator)) {
            generatorHandlers.put(generator, handler);
            return true;
        }
        CoFHWorld.log.error("Attempted to register duplicate generator '{}'!", (Object)generator);
        return false;
    }

    public static void addFiles(ArrayList<File> list, File folder) {
        String logPath = WorldProps.worldGenPath.relativize(Paths.get(folder.getPath(), new String[0])).toString();
        CoFHWorld.log.trace("Scanning folder \"{}\": ", (Object)logPath);
        AtomicInteger dirs = new AtomicInteger(0);
        File[] fList = folder.listFiles((file, name) -> {
            if (name == null) {
                return false;
            }
            if (new File(file, name).isDirectory()) {
                dirs.incrementAndGet();
                return !"includes".equalsIgnoreCase(name);
            }
            return name.toLowerCase(Locale.US).endsWith(".json");
        });
        if (fList == null || fList.length <= 0) {
            CoFHWorld.log.debug("There are no World Generation files present in \"{}\".", (Object)logPath);
            return;
        }
        int d = dirs.get();
        CoFHWorld.log.trace("Found {} World Generation files and {} folders present in \"{}\".", (Object)(fList.length - d), (Object)d, (Object)logPath);
        list.addAll(Arrays.asList(fList));
    }

    public static void processGenerationFiles() {
        CoFHWorld.log.info("Accumulating world generation files from: \"{}\"", (Object)WorldProps.worldGenDir.toString());
        ArrayList<File> worldGenList = new ArrayList<File>(5);
        int i = 0;
        if (WorldProps.replaceStandardGeneration) {
            CoFHWorld.log.info("Replacing standard generation with file \"{}\"", (Object)WorldProps.worldGenPath.relativize(Paths.get(WorldProps.standardGenFile.getPath(), new String[0])));
            worldGenList.add(WorldProps.standardGenFile);
            ++i;
        }
        FeatureParser.addFiles(worldGenList, WorldProps.worldGenDir);
        int e = worldGenList.size();
        while (i < e) {
            File genFile = worldGenList.get(i);
            if (genFile.equals(WorldProps.standardGenFile)) {
                worldGenList.remove(i);
                break;
            }
            ++i;
        }
        for (i = 0; i < worldGenList.size(); ++i) {
            File genFile = worldGenList.get(i);
            if (!genFile.isDirectory()) continue;
            worldGenList.remove(i--);
            FeatureParser.addFiles(worldGenList, genFile);
        }
        CoFHWorld.log.info("Found a total of {} world generation files.", (Object)worldGenList.size());
        ArrayList<ConfigContainer> processedGenList = new ArrayList<ConfigContainer>(worldGenList.size());
        int e2 = worldGenList.size();
        for (int i2 = 0; i2 < e2; ++i2) {
            Config genList;
            File genFile = worldGenList.get(i2);
            String file = WorldProps.worldGenPath.relativize(Paths.get(genFile.getPath(), new String[0])).toString();
            try {
                CoFHWorld.log.debug("Parsing world generation file: \"{}\"", (Object)file);
                genList = new CoFHOrderedParsableFile(genFile, Includer.options).parse().toConfig().resolve(Includer.resolveOptions);
            }
            catch (Throwable t) {
                CoFHWorld.log.fatal("Critical error reading from a world generation file: \"{}\" > Please be sure the file is correct!", (Object)genFile, (Object)t);
                continue;
            }
            if (genList.hasPath("dependencies") && !FeatureParser.processDependencies(genList.getValue("dependencies"))) {
                CoFHWorld.log.debug("Unmet dependencies to load file \"{}\"", (Object)file);
                continue;
            }
            if (genList.hasPath("enabled")) {
                ConfigValue en = genList.getValue("enabled");
                if (en.valueType() == ConfigValueType.BOOLEAN) {
                    if (!genList.getBoolean("enabled")) {
                        CoFHWorld.log.debug("Generation file \"{}\" is being skipped because it is disabled.", (Object)file);
                        continue;
                    }
                } else {
                    CoFHWorld.log.warn("Generation file \"{}\" is being skipped because the file's global `enabled` flag is not a boolean.", (Object)file);
                    continue;
                }
            }
            try {
                long pri = genList.hasPath("priority") ? genList.getLong("priority") : 0L;
                String namespace = genList.hasPath("namespace") ? genList.getString("namespace") + ":" : "";
                processedGenList.add(new ConfigContainer(genList, pri, namespace));
            }
            catch (Throwable t) {
                CoFHWorld.log.error("Error reading world generation file: \"{}\" > Please be sure the file is correct!", (Object)genFile, (Object)t);
                continue;
            }
            CoFHWorld.log.trace("World generation file \"{}\" ready to be processed", (Object)file);
        }
        processedGenList.sort((l, r) -> {
            long lv = l.priority;
            long rv = r.priority;
            return Long.compare(rv, lv);
        });
        FeatureParser.parseGenerationFiles(processedGenList);
    }

    public static boolean processDependencies(ConfigValue value) {
        if (value.valueType() == ConfigValueType.LIST) {
            ConfigList list = (ConfigList)value;
            boolean r = true;
            int e = list.size();
            for (int i = 0; i < e; ++i) {
                r &= FeatureParser.processDependency((ConfigValue)list.get(i));
            }
            return r;
        }
        return FeatureParser.processDependency(value);
    }

    public static boolean processDependency(ConfigValue value) {
        ModContainer con;
        String id;
        ArtifactVersion vers = null;
        boolean retComp = true;
        switch (value.valueType()) {
            case STRING: {
                id = (String)value.unwrapped();
                if (id.contains("@")) {
                    vers = VersionParser.parseVersionReference((String)id);
                    id = vers.getLabel();
                }
                con = (ModContainer)Loader.instance().getIndexedModList().get(id);
                break;
            }
            case OBJECT: {
                Config data = ((ConfigObject)value).toConfig();
                id = data.getString("id");
                con = (ModContainer)Loader.instance().getIndexedModList().get(id);
                if (data.hasPath("version")) {
                    vers = new DefaultArtifactVersion(id, data.getString("version"));
                }
                if (!data.hasPath("exclude")) break;
                retComp = !data.getBoolean("exclude");
                break;
            }
            default: {
                CoFHWorld.log.fatal("Invalid dependency at line {}!", (Object)value.origin().lineNumber());
                return false;
            }
        }
        if (con == null && (con = WorldHandler.getLoadedAPIs().get(id)) == null) {
            CoFHWorld.log.debug("Dependency '{}' is not loaded.", (Object)id);
            return false == retComp;
        }
        LoaderState.ModState state = Loader.instance().getModState(con);
        if (state == LoaderState.ModState.DISABLED || state == LoaderState.ModState.ERRORED) {
            CoFHWorld.log.debug("Dependency '{}' is disabled or crashed.", (Object)id);
            return false == retComp;
        }
        if (vers != null) {
            if (retComp != vers.containsVersion(con.getProcessedVersion())) {
                CoFHWorld.log.debug("Dependency '{}' has an incompatible version.", (Object)id);
                return false;
            }
            return true;
        }
        return true == retComp;
    }

    public static void parseGenerationFiles(ArrayList<ConfigContainer> processedGenList) {
        int e = processedGenList.size();
        for (int i = 0; i < e; ++i) {
            ConfigContainer genList = processedGenList.get(i);
            String file = WorldProps.worldGenPath.relativize(Paths.get(genList.config.origin().filename(), new String[0])).toString();
            CoFHWorld.log.info("Reading world generation info from: \"{}\":", (Object)file);
            FeatureParser.parseGenerationTag(genList, "populate", FeatureParser::parsePopulateEntry);
            FeatureParser.parseGenerationTag(genList, "structure", FeatureParser::parseStructureEntry);
            CoFHWorld.log.debug("Finished reading \"{}\"", (Object)file);
        }
    }

    public static void parseGenerationTag(ConfigContainer genList, String tag, BiFunction<String, Config, EnumActionResult> parseEntry) {
        if (genList.config.hasPath(tag)) {
            CoFHWorld.log.trace("Processing `{}` entries", (Object)tag);
            Config genData = genList.config.getConfig(tag);
            for (Map.Entry genEntry : genData.root().entrySet()) {
                String key = (String)genEntry.getKey();
                ConfigValue value = (ConfigValue)genEntry.getValue();
                try {
                    if (value.valueType() != ConfigValueType.OBJECT) {
                        CoFHWorld.log.error("Error parsing `{}` entry: '{}' > This must be an object and is not.", (Object)tag, (Object)key);
                        continue;
                    }
                    CoFHWorld.log.debug("Parsing `{}` entry '{}':", (Object)tag, (Object)key);
                    switch (parseEntry.apply(genList.namespace + key, genData.getConfig(key))) {
                        case SUCCESS: {
                            CoFHWorld.log.debug("Parsed `{}` entry successfully: '{}'", (Object)tag, (Object)key);
                            break;
                        }
                        case FAIL: {
                            CoFHWorld.log.error("Error parsing `{}` entry: '{}' > Please check the parameters.", (Object)tag, (Object)key);
                            break;
                        }
                        case PASS: {
                            CoFHWorld.log.error("Error parsing `{}` entry: '{}' > It is a duplicate.", (Object)tag, (Object)key);
                        }
                    }
                }
                catch (ConfigException ex) {
                    String line = "";
                    if (ex.origin() != null) {
                        line = String.format(" on line %s", ex.origin().lineNumber());
                    }
                    CoFHWorld.log.error("Error parsing `{}` entry '{}'{}: {}", (Object)tag, (Object)key, (Object)line, (Object)ex.getMessage());
                }
                catch (Throwable t) {
                    CoFHWorld.log.fatal("There was a severe error parsing `{}` entry '{}' on line {}!", (Object)tag, (Object)key, (Object)t, (Object)value.origin().lineNumber());
                }
            }
            CoFHWorld.log.trace("Finished processing `{}` entries", (Object)tag);
        } else {
            CoFHWorld.log.trace("File does not contain tag `{}`", (Object)tag);
        }
    }

    public static EnumActionResult parsePopulateEntry(String featureName, Config genObject) {
        if (genObject.hasPath("enabled") && !genObject.getBoolean("enabled")) {
            CoFHWorld.log.debug("\"{}\" is disabled.", (Object)featureName);
            return EnumActionResult.SUCCESS;
        }
        try {
            IFeatureGenerator feature = DistributionData.parseFeature(featureName, genObject);
            if (feature.getFeatureName() != null) {
                parsedFeatures.add(feature);
                return WorldHandler.registerFeature(feature) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            throw new IDistributionParser.InvalidDistributionException("Distribution doesn't have a name", genObject.origin());
        }
        catch (IDistributionParser.InvalidDistributionException e) {
            CoFHWorld.log.error("Distribution '{}' failed to parse its entry on line {}!", (Object)featureName, (Object)e.origin().lineNumber());
            CoFHWorld.log.catching(Level.DEBUG, (Throwable)e);
            return EnumActionResult.FAIL;
        }
    }

    public static EnumActionResult parseStructureEntry(String featureName, Config genObject) {
        if (genObject.hasPath("enabled") && !genObject.getBoolean("enabled")) {
            CoFHWorld.log.debug("\"{}\" is disabled.", (Object)featureName);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static class Includer
    implements ConfigIncluder,
    ConfigIncluderClasspath,
    ConfigIncluderFile,
    ConfigIncluderURL {
        public static Includer includer = new Includer();
        public static ConfigParseOptions options = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF).setIncluder(includer);
        public static ConfigResolveOptions resolveOptions = ConfigResolveOptions.noSystem();

        @Override
        public ConfigIncluder withFallback(ConfigIncluder fallback) {
            return this;
        }

        @Override
        public ConfigObject include(ConfigIncludeContext context, String what) {
            return this.includeFile(context, new File(what));
        }

        @Override
        @Nullable
        public ConfigObject includeFile(ConfigIncludeContext context, File file) {
            try {
                if (!FilenameUtils.directoryContains((String)WorldProps.worldGenDir.getCanonicalPath(), (String)file.getCanonicalPath())) {
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
            return new CoFHOrderedParsableFile(file, context.parseOptions()).parse();
        }

        @Override
        public ConfigObject includeResources(ConfigIncludeContext context, String what) {
            throw new IllegalArgumentException("Cannot include resources!");
        }

        @Override
        public ConfigObject includeURL(ConfigIncludeContext context, URL what) {
            throw new IllegalArgumentException("Cannot include URLs!");
        }
    }

    private static class ConfigContainer {
        public final Config config;
        public final long priority;
        public final String namespace;

        public ConfigContainer(Config config, long priority, String namespace) {
            this.config = config;
            this.priority = priority;
            this.namespace = namespace;
        }
    }
}

