/*
 * Decompiled with CFR 0.152.
 */
package javapower.storagetech.util;

import java.util.Collection;
import java.util.List;
import javapower.storagetech.proxy.ClientProxy;
import javapower.storagetech.util.Vector2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class Tools {
    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    public static AxisAlignedBB getBounds(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return new AxisAlignedBB((double)((float)fromX / 16.0f), (double)((float)fromY / 16.0f), (double)((float)fromZ / 16.0f), (double)((float)toX / 16.0f), (double)((float)toY / 16.0f), (double)((float)toZ / 16.0f));
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, Collection<AxisAlignedBB> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult hit = null;
        int i = -1;
        for (AxisAlignedBB aabb : boxes) {
            double d;
            AdvancedRayTraceResult result;
            AdvancedRayTraceResult advancedRayTraceResult = result = aabb == null ? null : Tools.collisionRayTrace(pos, start, end, aabb, i, null);
            if (result != null && (d = result.squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = result;
            }
            ++i;
        }
        return hit;
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB bounds, int subHit, Object hitInfo) {
        RayTraceResult result = bounds.func_186670_a(pos).func_72327_a(start, end);
        if (result == null) {
            return null;
        }
        result = new RayTraceResult(RayTraceResult.Type.BLOCK, result.field_72307_f, result.field_178784_b, pos);
        result.subHit = subHit;
        result.hitInfo = hitInfo;
        return new AdvancedRayTraceResult(result, bounds);
    }

    public static boolean PlayerIsOnList(List<EntityPlayerMP> entityPlayers, EntityPlayerMP entityPlayer) {
        if (entityPlayers != null && !entityPlayers.isEmpty()) {
            for (EntityPlayer entityPlayer2 : entityPlayers) {
                if (entityPlayer2.func_110124_au() != entityPlayer.getPersistentID()) continue;
                return true;
            }
        }
        return false;
    }

    public static void RemovePlayerOnList(List<EntityPlayerMP> entityPlayers, EntityPlayerMP entityPlayer) {
        if (entityPlayers != null && !entityPlayers.isEmpty()) {
            boolean isPresent = false;
            int id = 0;
            for (EntityPlayer entityPlayer2 : entityPlayers) {
                if (entityPlayer2.func_110124_au() == entityPlayer.getPersistentID()) {
                    isPresent = true;
                    break;
                }
                ++id;
            }
            if (isPresent) {
                entityPlayers.remove(id);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void GetMouseLocalisation(Vector2 mouspos, int width, int height, int xSize, int ySize) {
        int x = (width - xSize) / 2;
        int y = (height - ySize) / 2;
        float guiMPX = (float)ClientProxy.minecraft.field_71443_c / (float)width;
        float guiMPY = (float)ClientProxy.minecraft.func_71410_x().field_71440_d / (float)height;
        float guiMP = 0.0f;
        guiMP = guiMPX < guiMPY ? guiMPX : guiMPY;
        mouspos.x = (int)(((float)Mouse.getX() - (float)x * guiMP) / guiMP);
        mouspos.y = (int)(((float)(ClientProxy.minecraft.field_71440_d - Mouse.getY()) - (float)y * guiMP) / guiMP);
    }

    public static void GetMouseLocalisationNoMC(Vector2 mouspos, int vect, boolean middleZero) {
        if (middleZero) {
            mouspos.x = Mouse.getX() / vect - ClientProxy.minecraft.field_71443_c / (2 * vect);
            mouspos.y = (ClientProxy.minecraft.field_71440_d - Mouse.getY()) / vect - ClientProxy.minecraft.field_71440_d / (2 * vect);
        } else {
            mouspos.x = Mouse.getX() / vect;
            mouspos.y = (ClientProxy.minecraft.field_71440_d - Mouse.getY()) / vect;
        }
    }

    public static String longFormatToString(long bytes) {
        if (bytes < 1000L) {
            return "" + bytes;
        }
        int exp = (int)(Math.log(bytes) / Math.log(1000.0));
        String pre = "" + "kMGTPE".charAt(exp - 1);
        return String.format("%.1f %s", (double)bytes / Math.pow(1000.0, exp), pre);
    }

    public static boolean isJavaPower(EntityPlayer player) {
        return player.func_110124_au().toString().equalsIgnoreCase("6d89ae8c-01f7-498c-bb36-3f76ff9dfdc9");
    }

    public static int moyInteger(int[] in) {
        if (in == null || in.length <= 0) {
            return 0;
        }
        int out = 0;
        for (int i : in) {
            out += i;
        }
        return out / in.length;
    }

    public static EnumFacing getFacingForm2Blocks(BlockPos core, BlockPos satellit) {
        return EnumFacing.func_176737_a((float)(satellit.func_177958_n() - core.func_177958_n()), (float)(satellit.func_177956_o() - core.func_177956_o()), (float)(satellit.func_177952_p() - core.func_177952_p()));
    }

    public static <E> void AddOnListIfNotPresent(List<E> list, E element) {
        for (E e : list) {
            if (!e.equals(element)) continue;
            return;
        }
        list.add(element);
    }

    public static int limiteLTI(long v) {
        return (int)Math.min(v, Integer.MAX_VALUE);
    }

    public static class AdvancedRayTraceResult
    extends AdvancedRayTraceResultBase<RayTraceResult> {
        public AdvancedRayTraceResult(RayTraceResult mop, AxisAlignedBB bounds) {
            super(mop, bounds);
        }
    }

    private static class AdvancedRayTraceResultBase<T extends RayTraceResult> {
        public final AxisAlignedBB bounds;
        public final T hit;

        public AdvancedRayTraceResultBase(T mop, AxisAlignedBB bounds) {
            this.hit = mop;
            this.bounds = bounds;
        }

        public boolean valid() {
            return this.hit != null && this.bounds != null;
        }

        public double squareDistanceTo(Vec3d vec) {
            return ((RayTraceResult)this.hit).field_72307_f.func_72436_e(vec);
        }
    }
}

