/*
 * Decompiled with CFR 0.152.
 */
package javapower.storagetech.util;

import javapower.storagetech.eventio.IEventVoid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyBuffer
implements IEnergyStorage {
    public int energy;
    public int capacity;
    public int maxReceive;
    public int maxExtract;
    public IEventVoid eventchange = null;

    public EnergyBuffer(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public EnergyBuffer(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public EnergyBuffer(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public EnergyBuffer(int capacity, int maxReceive, int maxExtract, int energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0, Math.min(capacity, energy));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            if (this.eventchange != null && energyReceived > 0) {
                this.eventchange.event();
            }
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            if (this.eventchange != null && energyExtracted > 0) {
                this.eventchange.event();
            }
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public void WriteToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("energy", this.energy);
    }

    public boolean ReadFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("energy")) {
            this.energy = nbt.func_74762_e("energy");
            return true;
        }
        return false;
    }
}

