/*
 * Decompiled with CFR 0.152.
 */
package javapower.storagetech.proxy;

import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSyncData;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.UUID;
import javapower.storagetech.block.STBlocks;
import javapower.storagetech.core.ConfigClient;
import javapower.storagetech.item.STItems;
import javapower.storagetech.proxy.CommonProxy;
import javapower.storagetech.proxy.ResourceLocationRegister;
import javapower.storagetech.util.RegisterUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    public static Minecraft minecraft = Minecraft.func_71410_x();
    public static DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    public static DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        symbols.setGroupingSeparator(' ');
        formatter.setDecimalFormatSymbols(symbols);
        ConfigClient.init(e);
        super.preInit(e);
    }

    @Override
    public void init(FMLInitializationEvent e) {
        ResourceLocationRegister.register();
        super.init(e);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent e) {
        Field[] fields0 = STItems.class.getFields();
        RegisterUtils.RegisterIRender(fields0);
        Field[] fields1 = STBlocks.class.getFields();
        RegisterUtils.RegisterIRender(fields1);
    }

    @SubscribeEvent
    public void drawTooltip(RenderTooltipEvent.PostBackground event) {
        ItemStack itemstack;
        if (ConfigClient.overlayEnable && (itemstack = event.getStack()) != null && itemstack.func_77973_b() instanceof IStorageDiskProvider) {
            if (!((IStorageDiskProvider)itemstack.func_77973_b()).isValid(itemstack)) {
                return;
            }
            UUID uuid = ((IStorageDiskProvider)itemstack.func_77973_b()).getId(itemstack);
            if (uuid == null) {
                return;
            }
            IStorageDiskSyncData data = API.instance().getStorageDiskSync().getData(uuid);
            if (data != null) {
                if (data.getCapacity() != -1) {
                    float size = (float)data.getStored() / (float)data.getCapacity();
                    int color = size >= 0.75f ? (size >= 1.0f ? -65536 : -10240) : -16716307;
                    ClientProxy.minecraft.field_71446_o.func_110577_a(ResourceLocationRegister.overlay);
                    GuiUtils.drawTexturedModalRect((int)(event.getX() - 4), (int)(event.getY() - 24), (int)0, (int)0, (int)93, (int)20, (float)0.1f);
                    Gui.func_73734_a((int)event.getX(), (int)(event.getY() - 18), (int)(event.getX() + 60), (int)(event.getY() - 10), (int)-12303292);
                    if (size > 0.0f) {
                        Gui.func_73734_a((int)event.getX(), (int)(event.getY() - 18), (int)(event.getX() + (int)(60.0f * size)), (int)(event.getY() - 10), (int)color);
                    }
                    ClientProxy.minecraft.field_71466_p.func_78276_b((int)(size * 100.0f) + "%", event.getX() + 62, event.getY() - 17, color);
                } else {
                    ClientProxy.minecraft.field_71446_o.func_110577_a(ResourceLocationRegister.overlay);
                    GuiUtils.drawTexturedModalRect((int)(event.getX() - 4), (int)(event.getY() - 24), (int)0, (int)0, (int)93, (int)20, (float)0.1f);
                    ClientProxy.minecraft.field_71466_p.func_78276_b("Infinite", event.getX() + 25, event.getY() - 17, -16716307);
                }
            }
        }
    }
}

