/*
 * Decompiled with CFR 0.152.
 */
package javapower.storagetech.item;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.storage.StorageType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSyncData;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.List;
import java.util.UUID;
import javapower.storagetech.core.StorageTech;
import javapower.storagetech.item.ItemMemory;
import javapower.storagetech.util.IItemRegister;
import javapower.storagetech.util.IRenderItemRegister;
import javapower.storagetech.util.ItemRenderCast;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemFluidDiskCustom
extends Item
implements IItemRegister,
IStorageDiskProvider,
IRenderItemRegister {
    public ItemFluidDiskCustom() {
        this.setRegistryName("fluidcustomdisk");
        this.func_77655_b("fluidcustomdisk");
        this.func_77637_a(StorageTech.creativeTab);
        this.func_77625_d(1);
    }

    @Override
    public Item getItem() {
        return this;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K) {
            if (!this.isValid(stack)) {
                API.instance().getOneSixMigrationHelper().migrateDisk(world, stack);
            }
            if (!stack.func_77942_o()) {
                UUID id = UUID.randomUUID();
                API.instance().getStorageDiskManager(world).set(id, API.instance().createDefaultFluidDisk(world, this.getCapacity(stack)));
                API.instance().getStorageDiskManager(world).markForSaving();
                this.setId(stack, id);
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            IStorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}));
            }
            if (flag.func_194127_a()) {
                tooltip.add(id.toString());
            }
        }
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    @Override
    public ItemRenderCast[] getItemsRender() {
        return new ItemRenderCast[]{new ItemRenderCast(0, "fluidcustomdisk")};
    }

    public int getCapacity(ItemStack disk) {
        int cappacity = 1;
        if (disk != null && disk.func_77978_p() != null && disk.func_77978_p().func_74764_b("st_cap")) {
            cappacity = disk.func_77978_p().func_74762_e("st_cap");
        }
        return cappacity;
    }

    public UUID getId(ItemStack disk) {
        return disk.func_77978_p().func_186857_a("Id");
    }

    public StorageType getType() {
        return StorageType.FLUID;
    }

    public boolean isValid(ItemStack disk) {
        return disk.func_77942_o() && disk.func_77978_p().func_186855_b("Id") && disk.func_77978_p().func_74764_b("st_cap");
    }

    public void setId(ItemStack disk, UUID id) {
        disk.func_77982_d(new NBTTagCompound());
        disk.func_77978_p().func_186854_a("Id", id);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStack;
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && (itemStack = playerIn.func_184586_b(handIn)) != null && itemStack.func_77973_b() instanceof ItemFluidDiskCustom) {
            UUID id = this.getId(itemStack);
            API.instance().getStorageDiskSync().sendRequest(id);
            IStorageDiskSyncData storageData = API.instance().getStorageDiskSync().getData(id);
            if (storageData == null || storageData.getStored() <= 0) {
                int cap = itemStack.func_77978_p().func_74762_e("st_cap");
                ItemStack memory_item = ItemMemory.createItem(cap, true);
                playerIn.func_184611_a(handIn, new ItemStack((Item)RSItems.STORAGE_HOUSING, 1));
                if (cap > 0) {
                    playerIn.func_71019_a(memory_item, true);
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

