/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.client.gui;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.venus.client.gui.GuiLaserTurretEditList;
import micdoodle8.mods.galacticraft.planets.venus.client.gui.GuiLaserTurretEditPriority;
import micdoodle8.mods.galacticraft.planets.venus.inventory.ContainerLaserTurret;
import micdoodle8.mods.galacticraft.planets.venus.network.PacketSimpleVenus;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityLaserTurret;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class GuiLaserTurret
extends GuiContainerGC
implements GuiElementCheckbox.ICheckBoxCallback {
    private static final ResourceLocation backgroundTexture = new ResourceLocation("galacticraftplanets", "textures/gui/laser_turret.png");
    private final TileEntityLaserTurret laserTurret;
    private GuiElementCheckbox blacklistMode;
    private GuiElementCheckbox targetMeteors;
    private GuiButton buttonEditList;
    private GuiButton buttonEditPriority;
    private int cannotEditTimer;
    private GuiButton buttonEnable;
    private GuiElementInfoRegion electricInfoRegion;

    public GuiLaserTurret(InventoryPlayer par1InventoryPlayer, TileEntityLaserTurret turret) {
        super((Container)new ContainerLaserTurret(par1InventoryPlayer, turret));
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 107, (this.field_146295_m - this.field_147000_g) / 2 + 101, 56, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.laserTurret = turret;
        this.field_147000_g = 219;
        this.field_146999_f = 176;
    }

    protected void func_146284_a(GuiButton button) {
        if (!this.field_146297_k.field_71439_g.func_110124_au().equals(this.laserTurret.getOwnerUUID())) {
            this.cannotEditTimer = 50;
            return;
        }
        switch (button.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.laserTurret.func_174877_v(), 0}));
                this.laserTurret.setDisabled(0, !this.laserTurret.getDisabled(0));
                this.func_73866_w_();
                break;
            }
            case 3: {
                FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiLaserTurretEditList(this.laserTurret));
                break;
            }
            case 4: {
                FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiLaserTurretEditPriority(this.laserTurret));
            }
        }
    }

    public void func_73866_w_() {
        int yTop = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        super.func_73866_w_();
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.laserTurret.getEnergyStoredGC()) + " / " + (int)Math.floor(this.laserTurret.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 112;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 106;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 81, (this.field_146295_m - this.field_147000_g) / 2 + 92, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        String enableString = !this.laserTurret.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.disable.name") : GCCoreUtil.translate((String)"gui.button.enable.name");
        this.buttonEnable = new GuiButton(0, (this.field_146294_l - this.field_146999_f) / 2 + 7, this.field_146295_m / 2 - 9, 72, 20, enableString);
        this.field_146292_n.add(this.buttonEnable);
        this.blacklistMode = new GuiElementCheckbox(1, (GuiElementCheckbox.ICheckBoxCallback)this, this.field_146294_l / 2 - 81, yTop + 26, GCCoreUtil.translate((String)"gui.message.blacklist_mode.name"), ColorUtil.to32BitColor((int)255, (int)75, (int)75, (int)75));
        this.targetMeteors = new GuiElementCheckbox(2, (GuiElementCheckbox.ICheckBoxCallback)this, this.field_146294_l / 2 - 81, yTop + 40, GCCoreUtil.translate((String)"gui.message.target_meteors.name"), ColorUtil.to32BitColor((int)255, (int)75, (int)75, (int)75));
        this.buttonEditList = new GuiButton(3, (this.field_146294_l - this.field_146999_f) / 2 + this.field_146999_f / 2 - 41, yTop + 55, 82, 20, GCCoreUtil.translate((String)("gui.button.edit_" + (this.laserTurret.blacklistMode ? "blacklist" : "whitelist") + ".name")));
        this.field_146292_n.add(this.buttonEditList);
        this.buttonEditPriority = new GuiButton(4, (this.field_146294_l - this.field_146999_f) / 2 + this.field_146999_f / 2 - 41, yTop + 78, 82, 20, GCCoreUtil.translate((String)"gui.button.edit_priority.name"));
        this.field_146292_n.add(this.buttonEditPriority);
        this.field_146292_n.add(this.blacklistMode);
        this.field_146292_n.add(this.targetMeteors);
        this.field_146292_n.add(this.buttonEditList);
        this.field_146292_n.add(this.buttonEditPriority);
    }

    protected void func_146979_b(int par1, int par2) {
        this.buttonEnable.field_146124_l = this.laserTurret.disableCooldown == 0;
        String displayString = this.laserTurret.func_70005_c_();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 7, ColorUtil.to32BitColor((int)255, (int)75, (int)75, (int)75));
        displayString = GCCoreUtil.translate((String)"gui.message.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 18, ColorUtil.to32BitColor((int)255, (int)75, (int)75, (int)75));
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), 8, this.field_147000_g - 94, ColorUtil.to32BitColor((int)255, (int)75, (int)75, (int)75));
    }

    private String getStatus() {
        if (this.laserTurret.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (this.laserTurret.getEnergyStoredGC() < 1000.0f) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.missingpower.name");
        }
        return this.laserTurret.getGUIstatus();
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList electricityDesc = new ArrayList();
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.laserTurret.getEnergyStoredGC(), (float)this.laserTurret.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.func_73729_b(var5 + 101, var6 + 106, 176, 51, 67, 9);
        this.func_73729_b(var5 + 113, var6 + 107, 176, 0, Math.min(this.laserTurret.getScaledElecticalLevel(54), 54), 7);
        this.func_73729_b(var5 + 81, var6 + 102, 176, 33, 18, 18);
        if (this.laserTurret.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(var5 + 100, var6 + 107, 230, 0, 11, 8);
        }
        if (this.cannotEditTimer > 0) {
            --this.cannotEditTimer;
            this.blacklistMode.field_146124_l = false;
            this.targetMeteors.field_146124_l = false;
        } else {
            this.blacklistMode.field_146124_l = true;
            this.targetMeteors.field_146124_l = true;
        }
        this.blacklistMode.isSelected = this.laserTurret.blacklistMode;
        this.targetMeteors.isSelected = this.laserTurret.targetMeteors;
        this.buttonEditList.field_146126_j = GCCoreUtil.translate((String)("gui.button.edit_" + (this.laserTurret.blacklistMode ? "blacklist" : "whitelist") + ".name"));
        if (!this.field_146297_k.field_71439_g.func_110124_au().equals(this.laserTurret.getOwnerUUID())) {
            String displayString = this.laserTurret.func_70005_c_();
            boolean off = false;
            if (this.cannotEditTimer > 0) {
                off = this.cannotEditTimer % 30 < 15;
            }
            this.func_73729_b(var5 + this.field_146999_f / 2 + this.field_146289_q.func_78256_a(displayString) / 2 + (off ? -1 : 0) + 3, var6 + 5 + (off ? -1 : 0), 202 + (off ? 8 : 0), 7, off ? 10 : 8, off ? 12 : 10);
        }
    }

    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        this.cannotEditTimer = 40;
        if (checkbox.equals(this.blacklistMode)) {
            this.laserTurret.blacklistMode = newSelected;
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleVenus(PacketSimpleVenus.EnumSimplePacketVenus.S_UPDATE_ADVANCED_GUI, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{0, this.laserTurret.func_174877_v(), this.laserTurret.blacklistMode ? 1 : 0}));
        } else if (checkbox.equals(this.targetMeteors)) {
            this.laserTurret.targetMeteors = newSelected;
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleVenus(PacketSimpleVenus.EnumSimplePacketVenus.S_UPDATE_ADVANCED_GUI, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{1, this.laserTurret.func_174877_v(), this.laserTurret.targetMeteors ? 1 : 0}));
        }
    }

    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return player.func_110124_au().equals(this.laserTurret.getOwnerUUID()) && this.cannotEditTimer <= 0;
    }

    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        if (checkbox.equals(this.blacklistMode)) {
            return this.laserTurret.blacklistMode;
        }
        if (checkbox.equals(this.targetMeteors)) {
            return this.laserTurret.targetMeteors;
        }
        return false;
    }

    public void onIntruderInteraction() {
        this.cannotEditTimer = 50;
    }
}

