/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.Reference;
import techreborn.api.recipe.ITileRecipeHandler;
import techreborn.api.recipe.machines.IndustrialSawmillRecipe;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileGenericMachine;
import techreborn.tiles.multiblock.MultiblockChecker;

@RebornRegistry(modID="techreborn")
public class TileIndustrialSawmill
extends TileGenericMachine
implements IContainerProvider,
ITileRecipeHandler<IndustrialSawmillRecipe> {
    @ConfigRegistry(config="machines", category="industrial_sawmill", key="IndustrialSawmillMaxInput", comment="Industrial Sawmill Max Input (Value in EU)")
    public static int maxInput = 128;
    @ConfigRegistry(config="machines", category="industrial_sawmill", key="IndustrialSawmillMaxEnergy", comment="Industrial Sawmill Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    public static final int TANK_CAPACITY = 16000;
    public Tank tank;
    public MultiblockChecker multiblockChecker;
    int ticksSinceLastChange;

    public TileIndustrialSawmill() {
        super("IndustrialSawmill", maxInput, maxEnergy, ModBlocks.INDUSTRIAL_SAWMILL, 6);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4};
        this.inventory = new Inventory(7, "TileSawmill", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.INDUSTRIAL_SAWMILL_RECIPE, (TileEntity)this, 1, 3, this.inventory, inputs, outputs);
        this.tank = new Tank("TileSawmill", 16000, (TileLegacyMachineBase)this);
    }

    public boolean getMutliBlock() {
        if (this.multiblockChecker == null) {
            return false;
        }
        boolean down = this.multiblockChecker.checkRectY(1, 1, "standard", MultiblockChecker.ZERO_OFFSET);
        boolean up = this.multiblockChecker.checkRectY(1, 1, "standard", new BlockPos(0, 2, 0));
        boolean blade = this.multiblockChecker.checkRingY(1, 1, "reinforced", new BlockPos(0, 1, 0));
        IBlockState centerBlock = this.multiblockChecker.getBlock(0, 1, 0);
        boolean center = (centerBlock.func_177230_c() instanceof BlockLiquid || centerBlock.func_177230_c() instanceof IFluidBlock) && centerBlock.func_185904_a() == Material.field_151586_h;
        return down && center && blade && up;
    }

    @Override
    public void func_73660_a() {
        if (this.multiblockChecker == null) {
            BlockPos downCenter = this.field_174879_c.func_177967_a(this.getFacing().func_176734_d(), 2).func_177977_b();
            this.multiblockChecker = new MultiblockChecker(this.field_145850_b, downCenter);
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L && !this.inventory.func_70301_a(1).func_190926_b()) {
            FluidUtils.drainContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)1, (int)5);
            FluidUtils.fillContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)1, (int)5, (Fluid)this.tank.getFluidType());
        }
        if (!this.field_145850_b.field_72995_K && this.getMutliBlock()) {
            super.func_73660_a();
        }
        this.tank.compareAndUpdate();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 1) {
            return itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        return super.func_94041_b(slotIndex, itemStack);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("industrialsawmill").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).fluidSlot(1, 34, 35).slot(0, 84, 43).outputSlot(2, 126, 25).outputSlot(3, 126, 43).outputSlot(4, 126, 61).outputSlot(5, 34, 55).energySlot(6, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((TileLegacyMachineBase)this);
    }

    @Override
    public boolean canCraft(TileEntity tile, IndustrialSawmillRecipe recipe) {
        if (!this.getMutliBlock()) {
            return false;
        }
        FluidStack recipeFluid = recipe.fluidStack;
        FluidStack tankFluid = this.tank.getFluid();
        if (recipe.fluidStack == null) {
            return true;
        }
        if (tankFluid == null) {
            return false;
        }
        return tankFluid.isFluidEqual(recipeFluid) && tankFluid.amount >= recipeFluid.amount;
    }

    @Override
    public boolean onCraft(TileEntity tile, IndustrialSawmillRecipe recipe) {
        FluidStack recipeFluid = recipe.fluidStack;
        FluidStack tankFluid = this.tank.getFluid();
        if (recipe.fluidStack == null) {
            return true;
        }
        if (tankFluid == null) {
            return false;
        }
        if (tankFluid.isFluidEqual(recipeFluid) && tankFluid.amount >= recipeFluid.amount) {
            if (tankFluid.amount == recipeFluid.amount) {
                this.tank.setFluid(null);
            } else {
                tankFluid.amount -= recipeFluid.amount;
            }
            this.syncWithAll();
            return true;
        }
        return false;
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

