/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.api.generator.EFluidGenerator;
import techreborn.init.ModBlocks;
import techreborn.tiles.generator.TileBaseFluidGenerator;

@RebornRegistry(modID="techreborn")
public class TileThermalGenerator
extends TileBaseFluidGenerator
implements IContainerProvider {
    @ConfigRegistry(config="generators", category="thermal_generator", key="ThermalGeneratorMaxOutput", comment="Thermal Generator Max Output (Value in EU)")
    public static int maxOutput = 128;
    @ConfigRegistry(config="generators", category="thermal_generator", key="ThermalGeneratorMaxEnergy", comment="Thermal Generator Max Energy (Value in EU)")
    public static int maxEnergy = 1000000;
    @ConfigRegistry(config="generators", category="thermal_generator", key="ThermalGeneratorTankCapacity", comment="Thermal Generator Tank Capacity")
    public static int tankCapacity = 10000;
    @ConfigRegistry(config="generators", category="thermal_generator", key="ThermalGeneratorEnergyPerTick", comment="Thermal Generator Energy Per Tick (Value in EU)")
    public static int energyPerTick = 16;

    public TileThermalGenerator() {
        super(EFluidGenerator.THERMAL, "TileThermalGenerator", tankCapacity, energyPerTick);
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.THERMAL_GENERATOR, 1);
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    @Override
    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("thermalgenerator").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).fluidSlot(0, 25, 35).outputSlot(1, 25, 55).syncEnergyValue().syncIntegerValue(this::getTicksSinceLastChange, this::setTicksSinceLastChange).addInventory().create((TileLegacyMachineBase)this);
    }
}

