/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileDragonEggSyphon
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider {
    @ConfigRegistry(config="generators", category="dragon_egg_siphoner", key="DragonEggSiphonerMaxOutput", comment="Dragon Egg Siphoner Max Output (Value in EU)")
    public static int maxOutput = 128;
    @ConfigRegistry(config="generators", category="dragon_egg_siphoner", key="DragonEggSiphonerMaxEnergy", comment="Dragon Egg Siphoner Max Energy (Value in EU)")
    public static int maxEnergy = 1000;
    @ConfigRegistry(config="generators", category="dragon_egg_siphoner", key="DragonEggSiphonerEnergyPerTick", comment="Dragon Egg Siphoner Energy Per Tick (Value in EU)")
    public static int energyPerTick = 4;
    public Inventory inventory = new Inventory(3, "TileDragonEggSyphon", 64, (TileEntity)this);
    private long lastOutput = 0L;

    private boolean tryAddingEnergy(int amount) {
        if (this.getMaxPower() - this.getEnergy() >= (double)amount) {
            this.addEnergy(amount);
            return true;
        }
        if (this.getMaxPower() - this.getEnergy() > 0.0) {
            this.addEnergy(this.getMaxPower() - this.getEnergy());
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p())).func_177230_c() == Blocks.field_150380_bt && this.tryAddingEnergy(energyPerTick)) {
                this.lastOutput = this.field_145850_b.func_82737_E();
            }
            if (this.field_145850_b.func_82737_E() - this.lastOutput < 30L && !this.isActive()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
            } else if (this.field_145850_b.func_82737_E() - this.lastOutput > 30L && this.isActive()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.DRAGON_EGG_SYPHON, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

