/*
 * Decompiled with CFR 0.152.
 */
package techreborn.proxies;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import prospector.shootingstar.ShootingStar;
import reborncore.api.tile.IUpgradeable;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.GuiFluidConfiguration;
import reborncore.client.gui.builder.slot.GuiSlotConfiguration;
import reborncore.client.hud.StackInfoElement;
import reborncore.client.hud.StackInfoHUD;
import techreborn.blocks.BlockRubberLeaves;
import techreborn.client.ClientEventHandler;
import techreborn.client.RegisterItemJsons;
import techreborn.client.keybindings.KeyBindings;
import techreborn.client.render.ModelDynamicCell;
import techreborn.client.render.entitys.RenderNukePrimed;
import techreborn.entities.EntityNukePrimed;
import techreborn.events.FluidBlockModelHandler;
import techreborn.events.StackToolTipEvent;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemDynamicCell;
import techreborn.items.ItemFrequencyTransmitter;
import techreborn.proxies.CommonProxy;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ShootingStar.registerModels((String)"techreborn");
        StackInfoHUD.registerElement((StackInfoElement)new ItemFrequencyTransmitter.StackInfoFreqTransmitter());
        RenderingRegistry.registerEntityRenderingHandler(EntityNukePrimed.class, (IRenderFactory)new RenderManagerNuke());
        ModelDynamicCell.init();
        RegisterItemJsons.registerModels();
        MinecraftForge.EVENT_BUS.register((Object)new FluidBlockModelHandler());
        MinecraftForge.EVENT_BUS.register(ClientEventHandler.class);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new StackToolTipEvent());
        MinecraftForge.EVENT_BUS.register(GuiSlotConfiguration.class);
        MinecraftForge.EVENT_BUS.register(GuiFluidConfiguration.class);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.config);
        StateMap rubberLeavesStateMap = new StateMap.Builder().func_178442_a(new IProperty[]{BlockRubberLeaves.field_176236_b, BlockRubberLeaves.field_176237_a}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)ModBlocks.RUBBER_LEAVES, (IStateMapper)rubberLeavesStateMap);
        GuiBase.wrenchStack = new ItemStack(ModItems.WRENCH);
        GuiBase.fluidCellProvider = ItemDynamicCell::getCellWithFluid;
    }

    @Override
    public boolean isCTMAvailable() {
        return isChiselAround;
    }

    @Override
    public String getUpgradeConfigText() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiBase) {
            GuiBase base = (GuiBase)Minecraft.func_71410_x().field_71462_r;
            if (base.tile instanceof IUpgradeable && ((IUpgradeable)base.tile).canBeUpgraded()) {
                return TextFormatting.LIGHT_PURPLE + "Right click to configure";
            }
        }
        return super.getUpgradeConfigText();
    }

    @Override
    public boolean fancyGraphics() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    @Override
    public void rebuildRecipeBook() {
        super.rebuildRecipeBook();
        RecipeBookClient.rebuildTable();
    }

    public class RenderManagerNuke
    implements IRenderFactory<EntityNukePrimed> {
        public Render<? super EntityNukePrimed> createRenderFor(RenderManager manager) {
            return new RenderNukePrimed(manager);
        }
    }
}

