/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.TorchHelper;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.utils.TechRebornCreativeTab;

public class ItemOmniTool
extends ItemPickaxe
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.OmniToolCharge;
    public int cost = 100;
    public int hitCost = 125;

    public ItemOmniTool() {
        super(Item.ToolMaterial.DIAMOND);
        this.field_77864_a = 13.0f;
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77625_d(1);
        this.func_77656_e(200);
        this.func_77655_b("techreborn.omniTool");
    }

    public boolean func_150897_b(IBlockState state) {
        return Items.field_151056_x.func_150897_b(state) || Items.field_151048_u.func_150897_b(state) || Items.field_151046_w.func_150897_b(state) || Items.field_151047_v.func_150897_b(state) || Items.field_151097_aZ.func_150897_b(state);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        capEnergy.extractEnergy(this.cost, false);
        ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityLiving);
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        if (capEnergy.getEnergyStored() >= this.hitCost) {
            capEnergy.extractEnergy(this.hitCost, false);
            ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityliving);
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 8.0f);
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return TorchHelper.placeTorch((ItemStack)playerIn.func_184586_b(hand), (EntityPlayer)playerIn, (World)worldIn, (BlockPos)pos, (EnumFacing)facing, (float)hitX, (float)hitY, (float)hitZ, (EnumHand)hand);
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextFormatting.RED + "WIP Coming Soon");
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        ItemStack uncharged = new ItemStack(ModItems.OMNI_TOOL);
        ItemStack charged = new ItemStack(ModItems.OMNI_TOOL);
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(charged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        itemList.add((Object)uncharged);
        itemList.add((Object)charged);
    }

    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return 1000.0;
    }
}

