/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.ingredients.output.FluidStackOutputIngredient;
import reborncore.api.praescriptum.ingredients.output.ItemStackOutputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.common.util.ItemUtils;

public abstract class RecipeWrapper
implements IRecipeWrapper {
    protected final Recipe recipe;
    protected final List<ItemStack> itemInputs = new ArrayList<ItemStack>();
    protected final List<FluidStack> fluidInputs = new ArrayList<FluidStack>();
    protected final List<ItemStack> itemOutputs = new ArrayList<ItemStack>();
    protected final List<FluidStack> fluidOutputs = new ArrayList<FluidStack>();

    public RecipeWrapper(Recipe recipe) {
        this.recipe = recipe;
        recipe.getInputIngredients().stream().filter(entry -> entry instanceof ItemStackInputIngredient).map(entry -> (ItemStack)entry.ingredient).collect(Collectors.toCollection(() -> this.itemInputs));
        recipe.getInputIngredients().stream().filter(entry -> entry instanceof OreDictionaryInputIngredient).flatMap(entry -> OreDictionary.getOres((String)((String)entry.ingredient)).stream().map(stack -> ItemUtils.setSize((ItemStack)stack, (int)entry.getCount()))).collect(Collectors.toCollection(() -> this.itemInputs));
        recipe.getInputIngredients().stream().filter(entry -> entry instanceof FluidStackInputIngredient).map(entry -> (FluidStack)entry.ingredient).collect(Collectors.toCollection(() -> this.fluidInputs));
        recipe.getOutputIngredients().stream().filter(entry -> entry instanceof ItemStackOutputIngredient).map(entry -> (ItemStack)entry.ingredient).collect(Collectors.toCollection(() -> this.itemOutputs));
        recipe.getOutputIngredients().stream().filter(entry -> entry instanceof FluidStackOutputIngredient).map(entry -> (FluidStack)entry.ingredient).collect(Collectors.toCollection(() -> this.fluidOutputs));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.itemInputs);
        ingredients.setInputs(VanillaTypes.FLUID, this.fluidInputs);
        ingredients.setOutputs(VanillaTypes.ITEM, this.itemOutputs);
        ingredients.setOutputs(VanillaTypes.FLUID, this.fluidOutputs);
    }
}

