/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.storage;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.common.BaseTileBlock;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;
import techreborn.init.ModBlocks;
import techreborn.tiles.lesu.TileLSUStorage;
import techreborn.utils.TechRebornCreativeTab;

public class BlockLSUStorage
extends BaseTileBlock {
    public BlockLSUStorage() {
        super(Material.field_151573_f);
        this.func_149647_a(TechRebornCreativeTab.instance);
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/energy", new IProperty[0]));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileLSUStorage tile;
        if (world.func_175625_s(pos) instanceof TileLSUStorage && (tile = (TileLSUStorage)world.func_175625_s(pos)) != null) {
            tile.removeFromNetwork();
        }
        super.func_180663_b(world, pos, state);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileLSUStorage();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemstack) {
        TileLSUStorage tile;
        super.func_180633_a(world, pos, state, player, itemstack);
        if (world.func_175625_s(pos) instanceof TileLSUStorage && (tile = (TileLSUStorage)world.func_175625_s(pos)) != null) {
            tile.rebuildNetwork();
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.func_190926_b() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (RebornCoreConfig.wrenchRequired) {
            drops.add((Object)new ItemStack(ModBlocks.MACHINE_FRAMES, 1, 0));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return this == block;
    }
}

