/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.WorldUtils;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModSounds;
import techreborn.items.ingredients.ItemParts;
import techreborn.items.tools.ItemElectricTreetap;
import techreborn.items.tools.ItemTreeTap;
import techreborn.utils.TechRebornCreativeTab;

public class BlockRubberLog
extends Block {
    public static PropertyDirection SAP_SIDE = PropertyDirection.func_177712_a((String)"sapside", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyBool HAS_SAP = PropertyBool.func_177716_a((String)"hassap");

    public BlockRubberLog() {
        super(Material.field_151575_d);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)SAP_SIDE, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185848_a);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 5);
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, new IProperty[0]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SAP_SIDE, HAS_SAP});
    }

    public IBlockState func_176203_a(int meta) {
        boolean hasSap = false;
        int tempMeta = meta;
        if (meta > 3) {
            hasSap = true;
            tempMeta -= 3;
        }
        EnumFacing facing = EnumFacing.func_176731_b((int)tempMeta);
        return this.func_176223_P().func_177226_a((IProperty)SAP_SIDE, (Comparable)facing).func_177226_a((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(hasSap));
    }

    public int func_176201_c(IBlockState state) {
        int tempMeta = 0;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)SAP_SIDE);
        switch (facing) {
            case SOUTH: {
                tempMeta = 0;
                break;
            }
            case WEST: {
                tempMeta = 1;
                break;
            }
            case NORTH: {
                tempMeta = 2;
                break;
            }
            case EAST: {
                tempMeta = 3;
                break;
            }
            case UP: {
                tempMeta = 0;
                break;
            }
            case DOWN: {
                tempMeta = 0;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)HAS_SAP)).booleanValue()) {
            tempMeta += 4;
        }
        return tempMeta;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int i = 4;
        int j = i + 1;
        if (worldIn.func_175707_a(pos.func_177982_a(-j, -j, -j), pos.func_177982_a(j, j, j))) {
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-i, -i, -i), (BlockPos)pos.func_177982_a(i, i, i))) {
                IBlockState state1 = worldIn.func_180495_p(blockpos);
                if (!state1.func_177230_c().isLeaves(state1, (IBlockAccess)worldIn, blockpos)) continue;
                state1.func_177230_c().beginLeavesDecay(state1, worldIn, blockpos);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!((Boolean)state.func_177229_b((IProperty)HAS_SAP)).booleanValue() && rand.nextInt(50) == 0) {
            EnumFacing facing = EnumFacing.func_176731_b((int)rand.nextInt(4));
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SAP_SIDE, (Comparable)facing));
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_190926_b()) {
            return false;
        }
        ForgePowerItemManager capEnergy = null;
        if (stack.func_77973_b() instanceof ItemElectricTreetap) {
            capEnergy = new ForgePowerItemManager(stack);
        }
        if ((capEnergy != null && capEnergy.getEnergyStored() > 20 || stack.func_77973_b() instanceof ItemTreeTap) && ((Boolean)state.func_177229_b((IProperty)HAS_SAP)).booleanValue() && state.func_177229_b((IProperty)SAP_SIDE) == side) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SAP_SIDE, (Comparable)EnumFacing.func_176731_b((int)0)));
            worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModSounds.SAP_EXTRACT, SoundCategory.BLOCKS, 0.6f, 1.0f);
            if (!worldIn.field_72995_K) {
                if (capEnergy != null) {
                    capEnergy.extractEnergy(20, false);
                    ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)playerIn);
                } else {
                    playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77972_a(1, (EntityLivingBase)playerIn);
                }
                if (!playerIn.field_71071_by.func_70441_a(ItemParts.getPartByName("rubberSap").func_77946_l())) {
                    WorldUtils.dropItem((ItemStack)ItemParts.getPartByName("rubberSap").func_77946_l(), (World)worldIn, (BlockPos)pos.func_177972_a(side));
                }
                if (playerIn instanceof EntityPlayerMP) {
                    TRRecipeHandler.unlockTRRecipes((EntityPlayerMP)playerIn);
                }
            }
            return true;
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((Block)this));
        if (((Boolean)state.func_177229_b((IProperty)HAS_SAP)).booleanValue() && new Random().nextInt(4) == 0) {
            drops.add(ItemParts.getPartByName("rubberSap"));
        }
        return drops;
    }
}

