/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.common.BaseTileBlock;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;
import techreborn.tiles.TileAlarm;
import techreborn.utils.TechRebornCreativeTab;

public class BlockAlarm
extends BaseTileBlock {
    public static PropertyDirection FACING;
    public static PropertyBool ACTIVE;
    private AxisAlignedBB[] bbs;

    public BlockAlarm() {
        super(Material.field_151576_e);
        this.func_149663_c("techreborn.alarm");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.bbs = BlockAlarm.GenBoundingBoxes(0.19, 0.81);
        this.func_149647_a(TechRebornCreativeTab.instance);
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/lighting", new IProperty[0]));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    private static AxisAlignedBB[] GenBoundingBoxes(double depth, double width) {
        AxisAlignedBB[] dimm = new AxisAlignedBB[]{new AxisAlignedBB(width, 1.0 - depth, width, 1.0 - width, 1.0, 1.0 - width), new AxisAlignedBB(width, 0.0, width, 1.0 - width, depth, 1.0 - width), new AxisAlignedBB(width, width, 1.0 - depth, 1.0 - width, 1.0 - width, 1.0), new AxisAlignedBB(width, width, 0.0, 1.0 - width, 1.0 - width, depth), new AxisAlignedBB(1.0 - depth, width, width, 1.0, 1.0 - width, 1.0 - width), new AxisAlignedBB(0.0, width, width, depth, 1.0 - width, 1.0 - width)};
        return dimm;
    }

    public static boolean isActive(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE);
    }

    public static EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public static void setFacing(EnumFacing facing, World world, BlockPos pos) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    public static void setActive(boolean active, World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        IBlockState state = world.func_180495_p(pos).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)).func_177226_a((IProperty)FACING, (Comparable)facing);
        world.func_180501_a(pos, state, 3);
    }

    protected BlockStateContainer func_180661_e() {
        FACING = PropertyDirection.func_177714_a((String)"facing");
        ACTIVE = PropertyBool.func_177716_a((String)"active");
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.func_190926_b() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            ((TileAlarm)tileEntity).rightClick();
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        int activeInt = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0;
        return facingInt + activeInt;
    }

    public IBlockState func_176203_a(int meta) {
        Boolean active = (meta & 8) == 8;
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)ACTIVE, (Comparable)active);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAlarm();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bbs[BlockAlarm.getFacing(state).func_176745_a()];
    }

    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.tooltip.alarm", (Object[])new Object[0]));
    }
}

