/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import java.util.Random;
import lex.util.NumberHelper;
import lex.world.biome.BiomeWrapper;
import lex.world.gen.GenerationStage;
import lex.world.gen.feature.Feature;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nex.world.biome.NetherExBiomeManager;

@Mod.EventBusSubscriber(modid="nex")
public class FeatureGenHandler {
    @SubscribeEvent
    public static void onPrePopulateChunk(PopulateChunkEvent.Pre event) {
        if (event.getWorld().field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
            FeatureGenHandler.generateFeature(event.getWorld(), event.getChunkX(), event.getChunkZ(), event.getRand(), GenerationStage.PRE_POPULATE);
        }
    }

    @SubscribeEvent
    public static void onPopulateChunk(PopulateChunkEvent.Populate event) {
        if (event.getWorld().field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a() && event.getType() == PopulateChunkEvent.Populate.EventType.CUSTOM) {
            FeatureGenHandler.generateFeature(event.getWorld(), event.getChunkX(), event.getChunkZ(), event.getRand(), GenerationStage.POPULATE);
        }
    }

    @SubscribeEvent
    public static void onPostPopulateChunk(PopulateChunkEvent.Post event) {
        if (event.getWorld().field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
            FeatureGenHandler.generateFeature(event.getWorld(), event.getChunkX(), event.getChunkZ(), event.getRand(), GenerationStage.POST_POPULATE);
        }
    }

    @SubscribeEvent
    public static void onPreBiomeDecorate(DecorateBiomeEvent.Pre event) {
        if (event.getWorld().field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
            FeatureGenHandler.generateFeature(event.getWorld(), event.getPos(), event.getRand(), GenerationStage.PRE_DECORATE);
        }
    }

    @SubscribeEvent
    public static void onBiomeDecorate(DecorateBiomeEvent.Decorate event) {
        if (event.getWorld().field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a() && event.getType() == DecorateBiomeEvent.Decorate.EventType.CUSTOM) {
            FeatureGenHandler.generateFeature(event.getWorld(), event.getPos(), event.getRand(), GenerationStage.DECORATE);
        }
    }

    @SubscribeEvent
    public static void onPostBiomeDecorate(DecorateBiomeEvent.Post event) {
        if (event.getWorld().field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
            FeatureGenHandler.generateFeature(event.getWorld(), event.getPos(), event.getRand(), GenerationStage.POST_DECORATE);
        }
    }

    @SubscribeEvent
    public static void onPreGenerateOres(OreGenEvent.Pre event) {
        if (event.getWorld().field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
            FeatureGenHandler.generateFeature(event.getWorld(), event.getPos(), event.getRand(), GenerationStage.PRE_ORE);
        }
    }

    @SubscribeEvent
    public static void onGenerateOres(OreGenEvent.GenerateMinable event) {
        if (event.getWorld().field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a() && event.getType() == OreGenEvent.GenerateMinable.EventType.CUSTOM) {
            FeatureGenHandler.generateFeature(event.getWorld(), event.getPos(), event.getRand(), GenerationStage.ORE);
        }
    }

    @SubscribeEvent
    public static void onPostGenerateOres(OreGenEvent.Post event) {
        if (event.getWorld().field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
            FeatureGenHandler.generateFeature(event.getWorld(), event.getPos(), event.getRand(), GenerationStage.POST_ORE);
        }
    }

    private static void generateFeature(World world, int chunkX, int chunkZ, Random rand, GenerationStage generationStage) {
        BlockPos pos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        FeatureGenHandler.generateFeature(world, pos, rand, generationStage);
    }

    private static void generateFeature(World world, BlockPos pos, Random rand, GenerationStage generationStage) {
        BiomeWrapper wrapper = NetherExBiomeManager.getBiomeWrapper(world.func_180494_b(pos.func_177982_a(16, 0, 16)));
        if (wrapper != null) {
            for (Feature feature : wrapper.getFeatures(generationStage)) {
                for (int generationAttempts = 0; generationAttempts < feature.getGenAttempts(rand); ++generationAttempts) {
                    feature.func_180709_b(world, rand, pos.func_177982_a(rand.nextInt(16) + 8, NumberHelper.getNumberInRange((int)feature.getMinHeight(), (int)feature.getMaxHeight(), (Random)rand), rand.nextInt(16) + 8));
                }
            }
        }
    }
}

