/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import lex.IModData;
import lex.block.BlockLibEx;
import lex.util.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.NetherEx;
import nex.handler.ConfigHandler;
import nex.init.NetherExBlocks;
import nex.world.TeleporterNetherEx;

public class BlockNetherPortal
extends BlockLibEx {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 0.625, 1.0);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);

    public BlockNetherPortal() {
        super((IModData)NetherEx.instance, "nether_portal", Material.field_151567_E);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
        this.func_149675_a(true);
        this.func_149711_c(-1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.X) {
            if (world.func_175623_d(pos.func_177977_b()) || world.func_175623_d(pos.func_177984_a()) || world.func_175623_d(pos.func_177978_c()) || world.func_175623_d(pos.func_177968_d())) {
                world.func_175698_g(pos);
            }
        } else if (axis == EnumFacing.Axis.Y) {
            if (world.func_175623_d(pos.func_177978_c()) || world.func_175623_d(pos.func_177968_d()) || world.func_175623_d(pos.func_177976_e()) || world.func_175623_d(pos.func_177974_f())) {
                world.func_175698_g(pos);
            }
        } else if (axis == EnumFacing.Axis.Z && (world.func_175623_d(pos.func_177977_b()) || world.func_175623_d(pos.func_177984_a()) || world.func_175623_d(pos.func_177976_e()) || world.func_175623_d(pos.func_177974_f()))) {
            world.func_175698_g(pos);
        }
        if (world.field_73011_w.func_76569_d() && world.func_82736_K().func_82766_b("doMobSpawning") && ConfigHandler.blockConfig.netherPortal.pigmanSpawnRarity > 0 && rand.nextInt(ConfigHandler.blockConfig.netherPortal.pigmanSpawnRarity) < world.func_175659_aa().func_151525_a()) {
            Entity entity;
            int i = pos.func_177956_o();
            BlockPos blockPos = pos;
            while (!world.func_180495_p(blockPos).isSideSolid((IBlockAccess)world, blockPos, EnumFacing.UP) && blockPos.func_177956_o() > 0) {
                blockPos = blockPos.func_177977_b();
            }
            if (i > 0 && !world.func_180495_p(blockPos.func_177984_a()).func_185915_l() && (entity = ItemMonsterPlacer.func_77840_a((World)world, (ResourceLocation)EntityList.func_191306_a(EntityPigZombie.class), (double)((double)blockPos.func_177958_n() + 0.5), (double)((double)blockPos.func_177956_o() + 1.1), (double)((double)blockPos.func_177952_p() + 0.5))) != null) {
                entity.field_71088_bW = entity.func_82147_ab();
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175684_a(pos, (Block)this, 2);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.X) {
            if ((pos.func_177976_e().equals((Object)fromPos) || pos.func_177974_f().equals((Object)fromPos)) && world.func_180495_p(fromPos).func_177230_c() == this) {
                world.func_175698_g(fromPos);
            }
        } else if (axis == EnumFacing.Axis.Y) {
            if ((pos.func_177977_b().equals((Object)fromPos) || pos.func_177984_a().equals((Object)fromPos)) && world.func_180495_p(fromPos).func_177230_c() == this) {
                world.func_175698_g(fromPos);
            }
        } else if (axis == EnumFacing.Axis.Z && (pos.func_177978_c().equals((Object)fromPos) || pos.func_177968_d().equals((Object)fromPos)) && world.func_180495_p(fromPos).func_177230_c() == this) {
            world.func_175698_g(fromPos);
        }
        world.func_175684_a(pos, (Block)this, 1);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (entity.field_71088_bW > 0) {
                entity.field_71088_bW = entity.func_82147_ab();
            } else if (!world.field_72995_K) {
                WorldServer worldServer = (WorldServer)world;
                MinecraftServer minecraftServer = worldServer.func_73046_m();
                PlayerList playerList = minecraftServer.func_184103_al();
                int dimension = entity.field_71093_bK == DimensionType.NETHER.func_186068_a() ? DimensionType.OVERWORLD.func_186068_a() : DimensionType.NETHER.func_186068_a();
                TeleporterNetherEx teleporter = TeleporterNetherEx.getTeleporterForWorld(minecraftServer, dimension);
                entity.func_181015_d(pos);
                entity.field_71088_bW = entity.func_82147_ab();
                if (entity instanceof EntityPlayerMP) {
                    playerList.transferPlayerToDimension((EntityPlayerMP)entity, dimension, (Teleporter)teleporter);
                } else {
                    playerList.transferEntityToWorld(entity, entity.field_71093_bK, worldServer, minecraftServer.func_71218_a(dimension), (Teleporter)teleporter);
                }
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Y: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return BlockNetherPortal.getMetaForAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.values()[meta]);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public static int getMetaForAxis(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? 0 : (axis == EnumFacing.Axis.Y ? 1 : 2);
    }

    public boolean trySpawnPortal(World world, BlockPos pos) {
        for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
            for (EnumFacing facing : EnumFacing.values()) {
                Queue<BlockPos> portalBlocks = this.findPortalBlocks(world, pos.func_177972_a(facing), axis);
                if (portalBlocks.size() <= 0) continue;
                for (BlockPos newPos : portalBlocks) {
                    world.func_175656_a(newPos, this.func_176223_P().func_177226_a(AXIS, (Comparable)axis));
                }
                return true;
            }
        }
        return false;
    }

    private Queue<BlockPos> findPortalBlocks(World world, BlockPos pos, EnumFacing.Axis axis) {
        ArrayDeque portalBlocks = Queues.newArrayDeque();
        ArrayDeque toProcess = Queues.newArrayDeque();
        int chances = 0;
        toProcess.add(pos);
        while (!toProcess.isEmpty()) {
            BlockPos newPos = (BlockPos)toProcess.remove();
            if (portalBlocks.contains(newPos)) continue;
            if (world.func_175623_d(newPos) || world.func_180495_p(newPos).func_177230_c() == NetherExBlocks.BLUE_FIRE) {
                int neighborBlocks = this.getNeighborBlocks(world, newPos, portalBlocks, axis);
                if (neighborBlocks < 2) {
                    if (chances < 40) {
                        ++chances;
                        neighborBlocks += 2;
                    } else {
                        return Queues.newArrayDeque();
                    }
                }
                if (neighborBlocks >= 2) {
                    portalBlocks.add(newPos);
                    this.addNeighborBlocks(newPos, axis, toProcess);
                    continue;
                }
                if (this.isPortalPart(world, newPos)) continue;
                return Queues.newArrayDeque();
            }
            if (this.isPortalPart(world, newPos)) continue;
            return Queues.newArrayDeque();
        }
        return portalBlocks;
    }

    private int getNeighborBlocks(World world, BlockPos pos, Queue<BlockPos> portalBlocks, EnumFacing.Axis axis) {
        int sides = 0;
        ArrayDeque neighbors = Queues.newArrayDeque();
        this.addNeighborBlocks(pos, axis, neighbors);
        for (BlockPos newPos : neighbors) {
            if (!portalBlocks.contains(newPos) && !this.isPortalPart(world, newPos)) continue;
            ++sides;
        }
        return sides;
    }

    private void addNeighborBlocks(BlockPos pos, EnumFacing.Axis axis, Queue<BlockPos> neighbors) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (axis == EnumFacing.Axis.X && (facing == EnumFacing.EAST || facing == EnumFacing.WEST) || axis == EnumFacing.Axis.Y && (facing == EnumFacing.DOWN || facing == EnumFacing.UP) || axis == EnumFacing.Axis.Z && (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH)) continue;
            neighbors.add(pos.func_177972_a(facing));
        }
    }

    private boolean isPortalPart(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return BlockHelper.isOreDict((String)"obsidian", (Block)block) || block == NetherExBlocks.BLUE_FIRE || block == this;
    }
}

