/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.spawners.SpawnPotential;
import greymerk.roguelike.worldgen.spawners.Spawner;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;

public class Spawnable {
    private Spawner type;
    private List<SpawnPotential> potentials = new ArrayList<SpawnPotential>();

    public Spawnable(Spawner type) {
        this.type = type;
    }

    public Spawnable(JsonElement data) throws Exception {
        JsonArray arr = data.getAsJsonArray();
        for (JsonElement e : arr) {
            SpawnPotential potential = new SpawnPotential(e.getAsJsonObject());
            this.potentials.add(potential);
        }
    }

    public void generate(IWorldEditor editor, Random rand, Coord cursor, int level) {
        Coord pos = new Coord(cursor);
        editor.setBlock(pos, new MetaBlock(Blocks.field_150474_ac.func_176223_P()), true, true);
        TileEntity tileentity = editor.getTileEntity(pos);
        if (!(tileentity instanceof TileEntityMobSpawner)) {
            return;
        }
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileentity;
        MobSpawnerBaseLogic spawnerLogic = spawner.func_145881_a();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", pos.getX());
        nbt.func_74768_a("y", pos.getY());
        nbt.func_74768_a("z", pos.getZ());
        nbt.func_74782_a("SpawnPotentials", (NBTBase)this.getSpawnPotentials(rand, level));
        spawnerLogic.func_98270_a(nbt);
        spawnerLogic.func_98278_g();
        tileentity.func_70296_d();
    }

    private NBTTagList getSpawnPotentials(Random rand, int level) {
        if (this.type != null) {
            SpawnPotential potential = new SpawnPotential(Spawner.getName(this.type));
            return potential.get(rand, level);
        }
        NBTTagList potentials = new NBTTagList();
        for (SpawnPotential potential : this.potentials) {
            NBTTagCompound nbt = potential.get(level);
            potentials.func_74742_a((NBTBase)nbt);
        }
        return potentials;
    }
}

