/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pegbeard.dungeontactics.blocks.DTTrap;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.items.DTToolGeneric;

public class DTWrench
extends DTToolGeneric {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150462_ai, Blocks.field_150460_al, Blocks.field_150470_am, Blocks.field_150421_aI, Blocks.field_150323_B, Blocks.field_150367_z, Blocks.field_150409_cd, Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150442_at, Blocks.field_150471_bO, Blocks.field_150430_aB, Blocks.field_150452_aw, Blocks.field_150456_au, Blocks.field_150445_bS, Blocks.field_150443_bT, Blocks.field_150479_bC, Blocks.field_150379_bu, Blocks.field_150374_bv, Blocks.field_150453_bW, Blocks.field_180402_cm, Blocks.field_150438_bZ, Blocks.field_190976_dk, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc, DTBlocks.TRAP_AILMENT, DTBlocks.TRAP_AMBUSH, DTBlocks.TRAP_BOOM, DTBlocks.TRAP_FIRE, DTBlocks.TRAP_FOUL, DTBlocks.TRAP_PORT, DTBlocks.TRAP_SLIME, DTBlocks.TRAP_SPECTRAL, DTBlocks.POWERED_FENCE, DTBlocks.FAN_BLOCK, DTBlocks.FLAMER_BLOCK});

    public DTWrench(String name, Item.ToolMaterial material, float attackDamage, float attackSpeed) {
        super(name, material, attackDamage, attackSpeed, EFFECTIVE_ON);
    }

    public DTWrench(String name, Item.ToolMaterial material, float attackDamage, float attackSpeed, String ingot) {
        this(name, material, attackDamage, attackSpeed);
        this.func_77637_a(null);
    }

    public int func_77619_b() {
        return 10;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return enchant == Enchantments.field_185307_s || enchant == Enchantments.field_185305_q || enchant.func_92089_a(new ItemStack(Items.field_151010_B));
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (EFFECTIVE_ON.contains(state.func_177230_c())) {
            return 20.0f;
        }
        return 0.5f;
    }

    public boolean func_150897_b(IBlockState state) {
        return EFFECTIVE_ON.contains(state.func_177230_c());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.FAIL;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!player.func_175151_a(pos, facing, player.func_184586_b(hand))) {
            return EnumActionResult.PASS;
        }
        if (block instanceof DTTrap) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
            }
            player.func_184609_a(hand);
            if (player.func_70093_af()) {
                ((DTTrap)block).cycleHiddenState(world, pos);
            } else if (((DTTrap)block).isTriggered(world.func_180495_p(pos))) {
                ((DTTrap)block).setTriggeredState(world, pos, false);
            }
            return EnumActionResult.SUCCESS;
        }
        if (block.getValidRotations(world, pos) != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
            }
            if (!world.field_72995_K) {
                this.rotateBlock(world, pos, facing);
            }
            SoundType soundtype = block.getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185846_f(), SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            player.func_184609_a(hand);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (world.func_180495_p(pos).func_177230_c().getValidRotations(world, pos) != null) {
            IBlockState state = world.func_180495_p(pos);
            for (IProperty prop : state.func_177228_b().keySet()) {
                IBlockState newState;
                Block block;
                if (!prop.func_177701_a().equals("facing") && !prop.func_177701_a().equals("rotation") || prop.func_177699_b() != EnumFacing.class || (block = state.func_177230_c()) instanceof BlockBed || block instanceof BlockPistonExtension) continue;
                if (block instanceof BlockPistonBase && !((BlockPistonBase)block).rotateBlock(world, pos, axis)) {
                    return false;
                }
                IProperty facingProperty = prop;
                EnumFacing facing = (EnumFacing)state.func_177229_b(facingProperty);
                Collection validFacings = facingProperty.func_177700_c();
                if (facing == axis && validFacings.contains(axis.func_176734_d())) {
                    newState = state.func_177226_a(facingProperty, (Comparable)axis.func_176734_d());
                } else if (validFacings.contains(axis)) {
                    newState = state.func_177226_a(facingProperty, (Comparable)axis);
                } else {
                    EnumFacing rotatedFacing = facing.func_176732_a(axis.func_176740_k());
                    newState = validFacings.size() == 4 && !validFacings.contains(EnumFacing.UP) && !validFacings.contains(EnumFacing.DOWN) ? state.func_177226_a(facingProperty, (Comparable)facing.func_176746_e()) : (validFacings.contains(rotatedFacing) ? state.func_177226_a(facingProperty, (Comparable)rotatedFacing) : state.func_177231_a(facingProperty));
                }
                world.func_175656_a(pos, newState);
                world.func_175684_a(pos, world.func_180495_p(pos).func_177230_c(), 2);
                return true;
            }
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (target != null) {
            EntityPlayer player = (EntityPlayer)attacker;
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            target.field_70177_z = attacker.field_70759_as;
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            target.field_70177_z = player.field_70759_as;
            target.func_70034_d(player.field_70759_as);
            player.func_130014_f_().func_184133_a(player, player.func_180425_c(), SoundEvents.field_187724_dU, SoundCategory.PLAYERS, 1.0f, 0.9f);
            player.func_184609_a(hand);
        }
        return true;
    }
}

