/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import pegbeard.dungeontactics.entities.projectiles.DTEntityCherryBomb;
import pegbeard.dungeontactics.entities.projectiles.DTEntityFlint;
import pegbeard.dungeontactics.entities.projectiles.DTEntityGlowcurrent;
import pegbeard.dungeontactics.entities.projectiles.DTEntityIncindiberry;
import pegbeard.dungeontactics.entities.projectiles.DTEntitySeedBeetroot;
import pegbeard.dungeontactics.entities.projectiles.DTEntitySeedMelon;
import pegbeard.dungeontactics.entities.projectiles.DTEntitySeedNetherWart;
import pegbeard.dungeontactics.entities.projectiles.DTEntitySeedPumpkin;
import pegbeard.dungeontactics.entities.projectiles.DTEntitySeedWheat;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTCreativeTab;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.reference.Reference;

public class DTSlingShot
extends ItemBow {
    public DTSlingShot(String name) {
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_COMBAT_TAB);
        this.func_77625_d(1);
        this.func_77656_e(192);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.func_184607_cu().func_77973_b() != DTItems.SLINGSHOT ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean flag1 = !this.hasAmmo(player).func_190926_b();
        boolean flag2 = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)player.func_184586_b(hand)) > 0;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)player.func_184586_b(hand), (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag1);
        if (ret != null) {
            return ret;
        }
        if (!flag2 && !flag1) {
            return !flag1 ? new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand)) : new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private ItemStack hasAmmo(EntityPlayer player) {
        if (this.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isAmmo(@Nullable ItemStack stack) {
        if (stack.func_190926_b() || this.ammoBlackList(stack)) {
            return false;
        }
        NonNullList seedList = OreDictionary.getOres((String)"seeds");
        for (int i = 0; i < seedList.size(); ++i) {
            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)seedList.get(i)), (ItemStack)stack, (boolean)true)) continue;
            return true;
        }
        return this.ammoWhiteList(stack);
    }

    public boolean ammoWhiteList(ItemStack stack) {
        Property configPerms = DTConfigHandler.configuration.get("3-SlingshotAmmo", "1-Slingshot Ammo White List", Reference.SLINGSHOTWHITELISTDEFAULT);
        ArrayList<String> permsList = new ArrayList<String>(Arrays.asList(configPerms.getStringList()));
        if (permsList.isEmpty()) {
            return false;
        }
        String name = stack.func_77973_b().getRegistryName().toString();
        int id = DTSlingShot.func_150891_b((Item)stack.func_77973_b());
        return permsList.contains(name) || permsList.contains(Integer.toString(id));
    }

    public boolean ammoBlackList(ItemStack stack) {
        Property configPerms = DTConfigHandler.configuration.get("3-SlingshotAmmo", "2-Slingshot Ammo Black List", Reference.SLINGSHOTBLACKLISTDEFAULT);
        ArrayList<String> permsList = new ArrayList<String>(Arrays.asList(configPerms.getStringList()));
        if (permsList.isEmpty()) {
            return false;
        }
        String name = stack.func_77973_b().getRegistryName().toString();
        int id = DTSlingShot.func_150891_b((Item)stack.func_77973_b());
        return permsList.contains(name) || permsList.contains(Integer.toString(id));
    }

    public static float getProjectileVelocity(int charge) {
        float f = (float)charge / 10.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemStack ammoType = this.hasAmmo(player);
            boolean flag = player.field_71075_bZ.field_75098_d;
            boolean infinity = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            boolean fire = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0;
            int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            int kick = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (!ammoType.func_190926_b() || flag || infinity ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoType.func_190926_b() || flag || infinity) {
                float f;
                if (ammoType.func_190926_b() && flag) {
                    ammoType = new ItemStack(DTItems.CHERRYBOMB);
                }
                if (ammoType.func_190926_b() && infinity) {
                    ammoType = new ItemStack(Items.field_151145_ak);
                }
                if ((double)(f = DTSlingShot.getProjectileVelocity(i)) >= 0.2) {
                    if (!world.field_72995_K) {
                        DTEntitySeedWheat entityWheat = new DTEntitySeedWheat(world, (EntityLivingBase)player);
                        DTEntitySeedPumpkin entityPumpkin = new DTEntitySeedPumpkin(world, (EntityLivingBase)player);
                        DTEntitySeedMelon entityMelon = new DTEntitySeedMelon(world, (EntityLivingBase)player);
                        DTEntitySeedBeetroot entityBeetroot = new DTEntitySeedBeetroot(world, (EntityLivingBase)player);
                        DTEntitySeedNetherWart entityNetherwart = new DTEntitySeedNetherWart(world, (EntityLivingBase)player);
                        DTEntityFlint entityFlint = new DTEntityFlint(world, (EntityLivingBase)player);
                        DTEntityCherryBomb entityCherrybomb = new DTEntityCherryBomb(world, (EntityLivingBase)player);
                        DTEntityIncindiberry entityIncindiberry = new DTEntityIncindiberry(world, (EntityLivingBase)player);
                        DTEntityGlowcurrent entityGlowcurrent = new DTEntityGlowcurrent(world, (EntityLivingBase)player);
                        if (!flag) {
                            stack.func_77972_a(1, (EntityLivingBase)player);
                        }
                        float v = f * 1.5f;
                        if (ammoType.func_77973_b() == DTItems.CHERRYBOMB) {
                            entityCherrybomb.field_190534_ay = fire;
                            entityCherrybomb.damage = power;
                            entityCherrybomb.knockbackStrength = kick;
                            entityCherrybomb.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityCherrybomb);
                        } else if (ammoType.func_77973_b() == DTItems.INCINDIBERRY) {
                            entityIncindiberry.field_190534_ay = true;
                            entityIncindiberry.damage = power;
                            entityIncindiberry.knockbackStrength = kick;
                            entityIncindiberry.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityIncindiberry);
                        } else if (ammoType.func_77973_b() == DTItems.GLOWCURRENT) {
                            entityGlowcurrent.field_190534_ay = fire;
                            entityGlowcurrent.damage = power;
                            entityGlowcurrent.knockbackStrength = kick;
                            entityGlowcurrent.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityGlowcurrent);
                        } else if (ammoType.func_77973_b() == Items.field_151145_ak) {
                            entityFlint.field_190534_ay = fire;
                            entityFlint.damage = power;
                            entityFlint.knockbackStrength = kick;
                            if (flag || infinity) {
                                entityFlint.infinite = true;
                            }
                            entityFlint.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityFlint);
                        } else if (ammoType.func_77973_b() == Items.field_151075_bm) {
                            entityNetherwart.field_190534_ay = fire;
                            entityNetherwart.damage = power;
                            entityNetherwart.knockbackStrength = kick;
                            entityNetherwart.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityNetherwart);
                        } else if (ammoType.func_77973_b() == Items.field_151014_N) {
                            entityWheat.field_190534_ay = fire;
                            entityWheat.damage = power;
                            entityWheat.knockbackStrength = kick;
                            entityWheat.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityWheat);
                        } else if (ammoType.func_77973_b() == Items.field_151080_bb) {
                            entityPumpkin.field_190534_ay = fire;
                            entityPumpkin.damage = power;
                            entityPumpkin.knockbackStrength = kick;
                            entityPumpkin.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityPumpkin);
                        } else if (ammoType.func_77973_b() == Items.field_151081_bc) {
                            entityMelon.field_190534_ay = fire;
                            entityMelon.damage = power;
                            entityMelon.knockbackStrength = kick;
                            entityMelon.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityMelon);
                        } else if (ammoType.func_77973_b() == Items.field_185163_cU) {
                            entityBeetroot.field_190534_ay = fire;
                            entityBeetroot.damage = power;
                            entityBeetroot.knockbackStrength = kick;
                            entityBeetroot.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityBeetroot);
                        } else {
                            entityWheat.field_190534_ay = fire;
                            entityWheat.damage = power;
                            entityWheat.knockbackStrength = kick;
                            entityWheat.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, v, 1.0f);
                            world.func_72838_d((Entity)entityWheat);
                        }
                    }
                    world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag && !infinity) {
                        ammoType.func_190918_g(1);
                        if (ammoType.func_190926_b()) {
                            player.field_71071_by.func_184437_d(ammoType);
                        }
                    }
                }
            }
        }
    }
}

