/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emotes;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.vanity.client.emotes.EmoteBase;
import vazkii.quark.vanity.client.emotes.ModelAccessor;

@SideOnly(value=Side.CLIENT)
public class EmoteState {
    private float[] states = new float[0];
    private final EmoteBase emote;

    public EmoteState(EmoteBase emote) {
        this.emote = emote;
    }

    public void save(ModelBiped model) {
        float[] values = new float[1];
        for (int i = 0; i < 42; ++i) {
            ModelAccessor.INSTANCE.getValues(model, i, values);
            this.states[i] = values[0];
        }
    }

    public void load(ModelBiped model) {
        if (this.states.length == 0) {
            this.states = new float[42];
        } else {
            float[] values = new float[1];
            for (int i = 0; i < 42; ++i) {
                values[0] = this.states[i];
                int part = i / 6 * 6;
                if (!this.emote.usesBodyPart(part)) continue;
                ModelAccessor.INSTANCE.setValues(model, i, values);
            }
        }
    }

    public void rotateAndOffset(EntityPlayer player) {
        if (this.states.length == 0) {
            return;
        }
        float offsetX = this.states[39];
        float offsetY = this.states[40];
        float offsetZ = this.states[41];
        float rotX = this.states[36];
        float rotY = this.states[37];
        float rotZ = this.states[38];
        float height = player.field_70131_O;
        GlStateManager.func_179109_b((float)0.0f, (float)(height / 2.0f), (float)0.0f);
        GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)offsetZ);
        if (rotY != 0.0f) {
            GlStateManager.func_179114_b((float)(rotY * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotX != 0.0f) {
            GlStateManager.func_179114_b((float)(rotX * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rotZ != 0.0f) {
            GlStateManager.func_179114_b((float)(rotZ * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)(-height / 2.0f), (float)0.0f);
    }
}

