/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.item.ItemModBlock;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.client.ContributorRewardHandler;

public class ItemBlockTinyPotato
extends ItemModBlock {
    private static final List<String> TYPOS = Arrays.asList("vaskii", "vazki", "voskii", "vazkkii", "vazkki", "vazzki", "vaskki", "vozkii", "vazkil", "vaskil", "vazkill", "vaskill", "vaski");
    private static final int NOT_MY_NAME = 17;
    private static final String TAG_TICKS = "notMyNameTicks";

    public ItemBlockTinyPotato(Block block, ResourceLocation loc) {
        super(block, loc);
        this.func_185043_a(new ResourceLocation("quark", "angry"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"angery", (boolean)false) ? 1.0f : 0.0f;
            }
        });
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return super.isValidArmor(stack, armorType, entity) || entity instanceof EntityPlayer && ContributorRewardHandler.getTier((EntityPlayer)entity) > 0;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"angery", (boolean)false)) {
            return super.func_77667_c(stack) + ".angry";
        }
        return super.func_77667_c(stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity holder, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && holder instanceof EntityPlayer && holder.field_70173_aa % 30 == 0 && TYPOS.contains(stack.func_82833_r().toLowerCase())) {
            EntityPlayer player = (EntityPlayer)holder;
            int ticks = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_TICKS, (int)0);
            if (ticks < 17) {
                player.func_145747_a(new TextComponentTranslation("quarkmisc.you_came_to_the_wrong_neighborhood." + ticks, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_TICKS, (int)(ticks + 1));
            }
        }
    }
}

