/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.client.ModKeybinds;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.network.message.MessageDropoff;
import vazkii.quark.management.client.gui.GuiButtonChest;
import vazkii.quark.management.feature.ChestButtons;
import vazkii.quark.management.gamerule.DropoffGamerule;

public class StoreToChests
extends Feature {
    public static final String GAME_RULE = "quark_allowDropoff";
    public static boolean clientDisabled;
    public static boolean invert;
    public static int xPos;
    public static int yPos;
    public static int xPosC;
    public static int yPosC;
    public static List<String> classnames;

    @Override
    public void setupConfig() {
        invert = this.loadPropBool("Invert button", "If true the default will be to merge your items into nearby chests, otherwise hold shift for this functionality.", false);
        xPos = this.loadPropInt("Position X", "", 0);
        yPos = this.loadPropInt("Position Y ", "", 30);
        xPosC = this.loadPropInt("Position X (Creative)", "", 28);
        yPosC = this.loadPropInt("Position Y (Creative)", "", -20);
        Object[] classnamesArr = this.loadPropStringList("Forced GUIs", "GUIs in which the drop off button should be forced to show up. Use the \"Debug Classnames\" option in chest buttons to find the names.", new String[0]);
        classnames = Lists.newArrayList((Object[])classnamesArr);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new DropoffGamerule());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        ModKeybinds.initDropoffKey();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            clientDisabled = false;
        }
        if (event.getGui() instanceof GuiInventory || event.getGui() instanceof GuiContainerCreative || classnames.contains(event.getGui().getClass().getName())) {
            if (clientDisabled) {
                return;
            }
            GuiContainer guiInv = (GuiContainer)event.getGui();
            GuiContainerCreative creativeInv = null;
            if (guiInv instanceof GuiContainerCreative) {
                creativeInv = (GuiContainerCreative)guiInv;
            }
            if (creativeInv == null && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                return;
            }
            if (ChestButtons.chestButtons == null) {
                ChestButtons.chestButtons = new ArrayList<GuiButtonChest>();
            }
            ChestButtons.chestButtons.clear();
            Container container = guiInv.field_147002_h;
            for (Slot s : container.field_75151_b) {
                if (creativeInv == null && !(s instanceof SlotCrafting)) continue;
                if (creativeInv == null) {
                    ChestButtons.addButtonAndKeybind(event, GuiButtonChest.Action.DROPOFF, guiInv, 13211, s.field_75223_e + xPos, s.field_75221_f + yPos, ModKeybinds.dropoffKey);
                    break;
                }
                if (s.getSlotIndex() != 15) continue;
                ChestButtons.addButtonAndKeybind(event, GuiButtonChest.Action.DROPOFF, guiInv, 13211, s.field_75223_e + xPosC, s.field_75221_f + yPosC, ModKeybinds.dropoffKey, gui -> ((GuiContainerCreative)gui).func_147056_g() == CreativeTabs.field_78036_m.func_78021_a());
                break;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void performAction(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() instanceof GuiButtonChest && ((GuiButtonChest)event.getButton()).action == GuiButtonChest.Action.DROPOFF) {
            boolean smart = GuiScreen.func_146272_n() != invert;
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDropoff(smart, false));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void update(TickEvent.ClientTickEvent event) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiInventory) {
            GuiInventory inv = (GuiInventory)gui;
            if (ChestButtons.chestButtons == null) {
                ChestButtons.chestButtons = new ArrayList<GuiButtonChest>();
            }
            for (GuiButtonChest b : ChestButtons.chestButtons) {
                b.field_146128_h = inv.getGuiLeft() + b.shiftX;
                b.field_146129_i = inv.getGuiTop() + b.shiftY;
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

