/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiShulkerBox;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.api.ICustomSearchHandler;
import vazkii.quark.api.IItemSearchBar;
import vazkii.quark.api.capability.ISearchHandler;
import vazkii.quark.base.lib.LibMisc;
import vazkii.quark.base.module.Feature;
import vazkii.quark.management.feature.FavoriteItems;

public class ChestSearchBar
extends Feature {
    public static String text = "";
    public static GuiTextField searchBar;
    public static boolean skip;
    public static boolean moveToCenterBar;
    private long lastClick;
    private int matched;
    public static List<String> classnames;

    @Override
    public void setupConfig() {
        Object[] classnamesArr = this.loadPropStringList("Forced GUIs", "GUIs in which the sort button should be forced to show up. Use the \"Debug Classnames\" option in chest buttons to find the names.", new String[0]);
        classnames = Lists.newArrayList((Object[])classnamesArr);
        boolean invtweaks = this.loadPropBool("Avoid Invtweaks Buttons", "Automatically move the search bar if Inventory Tweaks is loaded so it doesn't end up in the same place as their buttons.", true);
        moveToCenterBar = this.loadPropBool("Move to Center Bar", "Set to true to move to the center bar, next to the \"Inventory\" text.", false);
        moveToCenterBar |= invtweaks && Loader.isModLoaded((String)"inventorytweaks");
    }

    @SubscribeEvent
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof IItemSearchBar || classnames.contains(gui.getClass().getName()) || gui instanceof GuiChest || gui instanceof GuiShulkerBox) {
            GuiContainer chest = (GuiContainer)gui;
            searchBar = new GuiTextField(12831, gui.field_146297_k.field_71466_p, chest.getGuiLeft() + 81, chest.getGuiTop() + 6, 88, 10);
            if (moveToCenterBar) {
                ChestSearchBar.searchBar.field_146210_g = chest.getGuiTop() + chest.getYSize() - 95;
            }
            searchBar.func_146180_a(text);
            searchBar.func_146195_b(false);
            searchBar.func_146203_f(32);
            searchBar.func_146185_a(false);
            if (gui instanceof IItemSearchBar) {
                ((IItemSearchBar)gui).onSearchBarAdded(searchBar);
            }
        } else {
            searchBar = null;
        }
    }

    @SubscribeEvent
    public void onKeypress(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (searchBar != null && searchBar.func_146206_l() && Keyboard.getEventKeyState()) {
            char eventChar = Keyboard.getEventCharacter();
            int eventCode = Keyboard.getEventKey();
            searchBar.func_146201_a(eventChar, eventCode);
            text = searchBar.func_146179_b();
            event.setCanceled(eventCode != 1);
        }
    }

    @SubscribeEvent
    public void onClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (searchBar != null && Mouse.getEventButtonState()) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiScreen gui = event.getGui();
            int x = Mouse.getEventX() * gui.field_146294_l / mc.field_71443_c;
            int y = gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / mc.field_71440_d - 1;
            int button = Mouse.getEventButton();
            searchBar.func_146192_a(x, y, button);
            long time = System.currentTimeMillis();
            long delta = time - this.lastClick;
            if (delta < 200L && searchBar.func_146206_l()) {
                searchBar.func_146180_a("");
                text = "";
            }
            this.lastClick = time;
        }
    }

    @SubscribeEvent
    public void onRender(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (searchBar != null && !skip) {
            this.renderElements(event.getGui());
        }
        skip = false;
    }

    @SubscribeEvent
    public void drawTooltipEvent(RenderTooltipEvent.Pre event) {
        if (searchBar != null) {
            this.renderElements(Minecraft.func_71410_x().field_71462_r);
            skip = true;
        }
    }

    private void renderElements(GuiScreen gui) {
        this.drawBackground(gui, ChestSearchBar.searchBar.field_146209_f - 2, ChestSearchBar.searchBar.field_146210_g - 2);
        if (!text.isEmpty() && gui instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)gui;
            Container container = guiContainer.field_147002_h;
            int guiLeft = guiContainer.getGuiLeft();
            int guiTop = guiContainer.getGuiTop();
            this.matched = 0;
            for (Slot s : container.field_75151_b) {
                ItemStack stack = s.func_75211_c();
                if (!ChestSearchBar.namesMatch(stack, text)) {
                    int x = guiLeft + s.field_75223_e;
                    int y = guiTop + s.field_75221_f;
                    GlStateManager.func_179097_i();
                    Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-1442840576);
                    continue;
                }
                ++this.matched;
            }
        }
        if (this.matched == 0 && !text.isEmpty()) {
            searchBar.func_146193_g(0xFF5555);
        } else {
            searchBar.func_146193_g(0xFFFFFF);
        }
        searchBar.func_146194_f();
    }

    private void drawBackground(GuiScreen gui, int x, int y) {
        if (gui instanceof IItemSearchBar && ((IItemSearchBar)gui).renderBackground(x, y) || gui == null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(LibMisc.GENERAL_ICONS_RESOURCE);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)244.0f, (int)90, (int)12, (float)256.0f, (float)256.0f);
    }

    public static boolean namesMatch(ItemStack stack, String search) {
        CreativeTabs tab;
        NBTTagCompound cmp;
        if ((search = TextFormatting.func_110646_a((String)search.trim().toLowerCase())) == null || search.isEmpty()) {
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemShulkerBox && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag", (boolean)true)) != null && cmp.func_150297_b("Items", 9)) {
            NonNullList itemList = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)cmp, (NonNullList)itemList);
            for (Object innerStack : itemList) {
                if (!ChestSearchBar.namesMatch((ItemStack)innerStack, search)) continue;
                return true;
            }
        }
        String name = stack.func_82833_r();
        name = TextFormatting.func_110646_a((String)name.trim().toLowerCase());
        ICustomSearchHandler.StringMatcher matcher = String::contains;
        if (search.length() >= 3 && search.startsWith("\"") && search.endsWith("\"")) {
            search = search.substring(1, search.length() - 1);
            matcher = String::equals;
        }
        if (search.length() >= 3 && search.startsWith("/") && search.endsWith("/")) {
            search = search.substring(1, search.length() - 1);
            matcher = (s1, s2) -> Pattern.compile(s2).matcher(s1).find();
        }
        if (stack.func_77948_v()) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
            for (Enchantment e : enchants.keySet()) {
                if (e == null || !matcher.matches(e.func_77316_c(((Integer)enchants.get(e)).intValue()).toLowerCase(), search)) continue;
                return true;
            }
        }
        ArrayList potionNames = new ArrayList();
        PotionUtils.func_185182_a((ItemStack)stack, potionNames, (float)1.0f);
        for (String s : potionNames) {
            if (!matcher.matches(TextFormatting.func_110646_a((String)s.trim().toLowerCase()), search)) continue;
            return true;
        }
        if (stack.func_77973_b() == Items.field_151134_bR) {
            NBTTagList enchants = ItemEnchantedBook.func_92110_g((ItemStack)stack);
            for (int i = 0; i < enchants.func_74745_c(); ++i) {
                NBTTagCompound cmp2 = enchants.func_150305_b(i);
                int id = cmp2.func_74762_e("id");
                int lvl = cmp2.func_74762_e("lvl");
                Enchantment e = Enchantment.func_185262_c((int)id);
                if (e == null || !matcher.matches(e.func_77316_c(lvl).toLowerCase(), search)) continue;
                return true;
            }
        }
        if ((tab = item.func_77640_w()) != null && matcher.matches(I18n.func_135052_a((String)tab.func_78024_c(), (Object[])new Object[0]).toLowerCase(), search)) {
            return true;
        }
        if (search.matches("favou?rites?") && FavoriteItems.isItemFavorited(stack)) {
            return true;
        }
        ResourceLocation itemName = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(Objects.requireNonNull(itemName).func_110624_b());
        if (matcher.matches(mod.getName().toLowerCase(), search)) {
            return true;
        }
        if (matcher.matches(name, search)) {
            return true;
        }
        return ISearchHandler.hasHandler(stack) && ISearchHandler.getHandler(stack).stackMatchesSearchQuery(search, matcher, ChestSearchBar::namesMatch);
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

