/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.tile.supplier;

import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.ITileAutomatorBlock;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.supplier.ITileAutomatorPowerSupplier;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.supplier.energy.EnergyCapabilityDelegate;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.supplier.fluid.FluidCapabilityDelegate;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.supplier.item.ItemCapabilityDelegate;
import com.codetaylor.mc.athenaeum.spi.TileEntityBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileAutomatorPowerSupplierRF
extends TileEntityBase
implements ITileAutomatorPowerSupplier {
    private final EnergyCapabilityDelegate energyCapabilityDelegate = new EnergyCapabilityDelegate();
    private final ItemCapabilityDelegate itemCapabilityDelegate = new ItemCapabilityDelegate();
    private final FluidCapabilityDelegate fluidCapabilityDelegate = new FluidCapabilityDelegate();

    @Override
    public boolean isPowered() {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (tileEntity instanceof ITileAutomatorBlock) {
            return ((ITileAutomatorBlock)tileEntity).isPowered();
        }
        return false;
    }

    public void neighborChanged() {
        this.updateCapabilityDelegates();
    }

    private void updateCapabilityDelegates() {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (tileEntity instanceof ITileAutomatorBlock) {
            this.energyCapabilityDelegate.setEnergyStorage((IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN));
            this.itemCapabilityDelegate.setItemHandler((IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN));
            this.fluidCapabilityDelegate.setFluidHandler((IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN));
        } else {
            this.energyCapabilityDelegate.setEnergyStorage(null);
            this.itemCapabilityDelegate.setItemHandler(null);
            this.fluidCapabilityDelegate.setFluidHandler(null);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            this.updateCapabilityDelegates();
            return (T)this.energyCapabilityDelegate;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.updateCapabilityDelegates();
            return (T)this.itemCapabilityDelegate;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            this.updateCapabilityDelegates();
            return (T)this.fluidCapabilityDelegate;
        }
        return null;
    }
}

