/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.fluid.data;

import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.TileAutomator;
import com.codetaylor.mc.artisanworktables.lib.IBooleanSupplier;
import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidHandler
extends ObservableFluidTank
implements ITileDataFluidTank {
    private FluidStack memoryStack;
    private final IBooleanSupplier locked;
    private final Supplier<TileAutomator.EnumFluidMode> mode;

    public FluidHandler(int capacity, IBooleanSupplier locked, Supplier<TileAutomator.EnumFluidMode> mode) {
        super(capacity);
        this.locked = locked;
        this.mode = mode;
    }

    public FluidStack getMemoryStack() {
        return this.memoryStack;
    }

    public boolean isLocked() {
        return this.locked.get();
    }

    public boolean updateMemory() {
        FluidStack fluid;
        if (this.locked.get() && (fluid = this.getFluid()) != null) {
            this.memoryStack = fluid.copy();
            return true;
        }
        return this.clearMemory();
    }

    private boolean clearMemory() {
        if (this.memoryStack != null) {
            this.memoryStack = null;
            return true;
        }
        return false;
    }

    public boolean clearAll() {
        FluidStack drained = super.drainInternal(this.getFluidAmount(), true);
        boolean memoryCleared = this.clearMemory();
        return drained != null && drained.amount > 0 || memoryCleared;
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("memoryStack")) {
            NBTTagCompound memoryStackTag = nbt.func_74775_l("memoryStack");
            this.memoryStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)memoryStackTag);
        } else {
            this.memoryStack = null;
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.memoryStack != null) {
            nbt.func_74782_a("memoryStack", (NBTBase)this.memoryStack.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        if (this.mode.get() != TileAutomator.EnumFluidMode.Fill) {
            return 0;
        }
        if (this.locked.get() && !resource.isFluidEqual(this.memoryStack)) {
            return 0;
        }
        int filled = super.fillInternal(resource, doFill);
        if (doFill && !this.locked.get() && filled > 0) {
            this.memoryStack = resource.copy();
        }
        return filled;
    }

    @Nullable
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        if (this.mode.get() != TileAutomator.EnumFluidMode.Drain) {
            return null;
        }
        FluidStack fluidStack = super.drainInternal(maxDrain, doDrain);
        if (doDrain && !this.locked.get() && fluidStack != null && fluidStack.amount > 0 && this.getFluidAmount() == 0) {
            this.memoryStack = null;
        }
        return fluidStack;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.fluid != null && this.fluid.amount > capacity) {
            this.forceDrain(this.fluid.amount - capacity);
        }
    }

    public FluidStack forceDrain(int maxDrain) {
        FluidStack fluidStack = super.drainInternal(maxDrain, true);
        if (!this.locked.get() && fluidStack != null && fluidStack.amount > 0 && this.getFluidAmount() == 0) {
            this.memoryStack = null;
        }
        return fluidStack;
    }
}

