/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.tile.automator;

import com.codetaylor.mc.artisanautomation.modules.automator.ModuleAutomator;
import com.codetaylor.mc.artisanautomation.modules.automator.ModuleAutomatorConfig;
import com.codetaylor.mc.artisanautomation.modules.automator.Util;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.AutomatorContainer;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.AutomatorGuiContainer;
import com.codetaylor.mc.artisanautomation.modules.automator.item.ItemUpgrade;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.AutomatorCraftingContext;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.ITileAutomatorBlock;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.ITileAutomatorPowerConsumer;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.energy.data.EnergyTank;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.fluid.FluidCapabilityWrapper;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.fluid.data.FluidHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.GhostItemInsertValidationItemHandlerWrapper;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.ItemCapabilityWrapper;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.BucketItemStackHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.InventoryGhostItemStackHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.InventoryItemStackHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.OutputItemStackHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.PatternItemStackHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.TableItemStackHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.ToolStackHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.ToolUpgradeStackHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.ToolboxStackHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.UpgradeItemStackHandler;
import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.ArtisanConfig;
import com.codetaylor.mc.artisanworktables.api.ArtisanToolHandlers;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingContext;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.IToolHandler;
import com.codetaylor.mc.artisanworktables.modules.worktables.block.BlockBase;
import com.codetaylor.mc.artisanworktables.modules.worktables.block.BlockWorkshop;
import com.codetaylor.mc.artisanworktables.modules.worktables.block.BlockWorkstation;
import com.codetaylor.mc.artisanworktables.modules.worktables.block.BlockWorktable;
import com.codetaylor.mc.artisanworktables.modules.worktables.item.ItemDesignPattern;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.CraftingMatrixStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataBoolean;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataEnergyStorage;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataEnum;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileDataBase;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.tile.IContainerProvider;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileAutomator
extends TileEntityDataBase
implements IContainerProvider<AutomatorContainer, AutomatorGuiContainer>,
ITileAutomatorPowerConsumer,
ITickable {
    private final TileDataEnergyStorage<EnergyTank> energyStorageData;
    private final EnergyTank energyStorage;
    private final TableItemStackHandler tableItemStackHandler;
    private final UpgradeItemStackHandler upgradeItemStackHandler;
    private final TileDataFloat progress;
    private float tickCounter;
    @SideOnly(value=Side.CLIENT)
    private int previousEnergy;
    private final PatternItemStackHandler patternItemStackHandler;
    private final OutputItemStackHandler[] outputItemStackHandler;
    private final boolean[] outputDirty;
    private final List<TileDataEnum<EnumOutputMode>> outputMode;
    private final InventoryItemStackHandler inventoryItemStackHandler;
    private final InventoryGhostItemStackHandler inventoryGhostItemStackHandler;
    private final TileDataBoolean inventoryLocked;
    private final FluidHandler[] fluidHandlers;
    private final List<TileDataFluidTank<FluidHandler>> fluidHandlerTileData;
    private final BucketItemStackHandler bucketItemStackHandler;
    private final List<TileDataEnum<EnumFluidMode>> fluidMode;
    private final List<TileDataBoolean> fluidLocked;
    private final boolean[] bucketUpdateRequired;
    private final ToolStackHandler toolStackHandler;
    private final ToolboxStackHandler toolboxStackHandler;
    private final ToolUpgradeStackHandler toolUpgradeStackHandler;
    private final ItemCapabilityWrapper itemCapabilityWrapper;
    private final FluidCapabilityWrapper fluidCapabilityWrapper;
    private final Stats stats = new Stats();
    private static final int AUTO_IMPORT_ITEMS_TICK_INTERVAL = 20;
    private int autoImportItemsTickCount;
    private static final int AUTO_IMPORT_FLUIDS_TICK_INTERVAL = 20;
    private int autoImportFluidsTickCount;

    public TileAutomator() {
        super(ModuleAutomator.TILE_DATA_SERVICE);
        int i;
        this.fluidHandlers = new FluidHandler[3];
        this.outputMode = new ArrayList<TileDataEnum<EnumOutputMode>>(9);
        this.energyStorage = new EnergyTank(ModuleAutomatorConfig.MECHANICAL_ARTISAN.RF_CAPACITY, ModuleAutomatorConfig.MECHANICAL_ARTISAN.RF_PER_TICK, Integer.MAX_VALUE);
        this.energyStorage.addObserver((energyStorage, amount) -> this.func_70296_d());
        this.tableItemStackHandler = new TableItemStackHandler();
        this.tableItemStackHandler.addObserver((stackHandler, slotIndex) -> this.func_70296_d());
        this.upgradeItemStackHandler = new UpgradeItemStackHandler();
        this.upgradeItemStackHandler.addObserver((stackHandler, slotIndex) -> {
            this.func_70296_d();
            this.stats.calculate(this.upgradeItemStackHandler);
            for (int i = 0; i < this.fluidHandlers.length; ++i) {
                this.fluidHandlers[i].setCapacity((int)((float)ModuleAutomatorConfig.MECHANICAL_ARTISAN.FLUID_CAPACITY * this.stats.getFluidCapacity().get()));
            }
            this.energyStorage.setCapacity((int)((float)ModuleAutomatorConfig.MECHANICAL_ARTISAN.RF_CAPACITY * this.stats.getEnergyCapacity().get()));
            if (!this.stats.getAutoExportItems().get()) {
                for (TileDataEnum<EnumOutputMode> outputMode : this.outputMode) {
                    if (outputMode.get() != EnumOutputMode.Export) continue;
                    outputMode.set((Enum)EnumOutputMode.Keep);
                }
            }
        });
        this.energyStorageData = new TileDataEnergyStorage((IEnergyStorage)this.energyStorage);
        this.progress = new TileDataFloat(0.0f);
        this.outputDirty = new boolean[9];
        Arrays.fill(this.outputDirty, true);
        this.patternItemStackHandler = new PatternItemStackHandler();
        this.patternItemStackHandler.addObserver((stackHandler, slotIndex) -> this.func_70296_d());
        this.outputItemStackHandler = new OutputItemStackHandler[9];
        for (i = 0; i < this.outputItemStackHandler.length; ++i) {
            int n = i;
            this.outputItemStackHandler[i] = new OutputItemStackHandler();
            this.outputItemStackHandler[i].addObserver((stackHandler, slotIndex) -> {
                this.func_70296_d();
                this.outputDirty[handlerIndex] = true;
            });
        }
        for (i = 0; i < 9; ++i) {
            this.outputMode.add((TileDataEnum<EnumOutputMode>)new TileDataEnum(EnumOutputMode::fromIndex, EnumOutputMode::getIndex, (Enum)EnumOutputMode.Keep));
        }
        this.inventoryGhostItemStackHandler = new InventoryGhostItemStackHandler();
        this.inventoryGhostItemStackHandler.addObserver((stackHandler, slotIndex) -> this.func_70296_d());
        this.inventoryItemStackHandler = new InventoryItemStackHandler(this::isInventoryLocked, this.inventoryGhostItemStackHandler);
        this.inventoryItemStackHandler.addObserver((stackHandler, slotIndex) -> this.func_70296_d());
        this.inventoryLocked = new TileDataBoolean(false);
        i = 0;
        while (i < this.fluidHandlers.length) {
            int n = i++;
            this.fluidHandlers[n] = new FluidHandler(ModuleAutomatorConfig.MECHANICAL_ARTISAN.FLUID_CAPACITY, () -> this.isFluidLocked(index), () -> this.getFluidMode(index));
            this.fluidHandlers[n].addObserver((fluidTank, amount) -> {
                this.func_70296_d();
                this.bucketUpdateRequired[index] = true;
            });
        }
        this.bucketItemStackHandler = new BucketItemStackHandler();
        this.bucketItemStackHandler.addObserver((stackHandler, slotIndex) -> {
            this.func_70296_d();
            this.bucketUpdateRequired[slotIndex] = true;
        });
        this.fluidMode = new ArrayList<TileDataEnum<EnumFluidMode>>(3);
        for (i = 0; i < 3; ++i) {
            this.fluidMode.add((TileDataEnum<EnumFluidMode>)new TileDataEnum(EnumFluidMode::fromIndex, EnumFluidMode::getIndex, (Enum)EnumFluidMode.Fill));
        }
        this.fluidLocked = new ArrayList<TileDataBoolean>(3);
        for (i = 0; i < 3; ++i) {
            this.fluidLocked.add(new TileDataBoolean(false));
        }
        this.bucketUpdateRequired = new boolean[3];
        this.toolStackHandler = new ToolStackHandler();
        this.toolStackHandler.addObserver((stackHandler, slotIndex) -> this.func_70296_d());
        this.toolboxStackHandler = new ToolboxStackHandler();
        this.toolboxStackHandler.addObserver((stackHandler, slotIndex) -> this.func_70296_d());
        this.toolUpgradeStackHandler = new ToolUpgradeStackHandler();
        this.toolUpgradeStackHandler.addObserver((stackHandler, slotIndex) -> this.func_70296_d());
        this.autoImportItemsTickCount = 0;
        this.autoImportFluidsTickCount = 10;
        this.itemCapabilityWrapper = new ItemCapabilityWrapper(this.inventoryItemStackHandler, this.inventoryGhostItemStackHandler, this.outputItemStackHandler, this.outputMode, this::isInventoryLocked);
        this.fluidCapabilityWrapper = new FluidCapabilityWrapper(this.fluidHandlers);
        ArrayList<TileDataBase> tileDataList = new ArrayList<TileDataBase>(Arrays.asList(this.energyStorageData, new TileDataItemStackHandler((ItemStackHandler)this.tableItemStackHandler), this.progress, new TileDataItemStackHandler((ItemStackHandler)this.patternItemStackHandler)));
        this.stats.registerNetwork(tileDataList);
        tileDataList.add((TileDataBase)new TileDataItemStackHandler((ItemStackHandler)this.upgradeItemStackHandler));
        for (OutputItemStackHandler outputItemStackHandler : this.outputItemStackHandler) {
            tileDataList.add((TileDataBase)new TileDataItemStackHandler((ItemStackHandler)outputItemStackHandler));
        }
        tileDataList.addAll(this.outputMode);
        tileDataList.add((TileDataBase)new TileDataItemStackHandler((ItemStackHandler)this.inventoryItemStackHandler));
        tileDataList.add((TileDataBase)new TileDataItemStackHandler((ItemStackHandler)this.inventoryGhostItemStackHandler));
        tileDataList.add((TileDataBase)this.inventoryLocked);
        this.fluidHandlerTileData = new ArrayList<TileDataFluidTank<FluidHandler>>(this.fluidHandlers.length);
        for (FluidHandler fluidHandler : this.fluidHandlers) {
            TileDataFluidTank tileData = new TileDataFluidTank((FluidTank)fluidHandler);
            this.fluidHandlerTileData.add((TileDataFluidTank<FluidHandler>)tileData);
            tileDataList.add((TileDataBase)tileData);
        }
        tileDataList.add((TileDataBase)new TileDataItemStackHandler((ItemStackHandler)this.bucketItemStackHandler));
        tileDataList.addAll(this.fluidMode);
        tileDataList.addAll(this.fluidLocked);
        tileDataList.add((TileDataBase)new TileDataItemStackHandler((ItemStackHandler)this.toolStackHandler));
        tileDataList.add((TileDataBase)new TileDataItemStackHandler((ItemStackHandler)this.toolboxStackHandler));
        this.registerTileDataForNetwork(tileDataList.toArray(new ITileData[0]));
    }

    public int getEnergyAmount() {
        return this.energyStorage.getEnergyStored();
    }

    public int getEnergyCapacity() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public TableItemStackHandler getTableItemStackHandler() {
        return this.tableItemStackHandler;
    }

    public UpgradeItemStackHandler getUpgradeItemStackHandler() {
        return this.upgradeItemStackHandler;
    }

    public float getProgress() {
        return this.progress.get();
    }

    public PatternItemStackHandler getPatternItemStackHandler() {
        return this.patternItemStackHandler;
    }

    public OutputItemStackHandler getOutputItemStackHandler(int index) {
        return this.outputItemStackHandler[index];
    }

    public EnumOutputMode getOutputMode(int slotIndex) {
        TileDataEnum<EnumOutputMode> tileData = this.outputMode.get(slotIndex);
        return (EnumOutputMode)tileData.get();
    }

    public void cycleOutputMode(int slotIndex) {
        TileDataEnum<EnumOutputMode> tileData = this.outputMode.get(slotIndex);
        EnumOutputMode enumOutputMode = (EnumOutputMode)tileData.get();
        int nextIndex = enumOutputMode.getIndex() + 1;
        if (!this.stats.getAutoExportItems().get() && nextIndex < EnumOutputMode.values().length && EnumOutputMode.fromIndex(nextIndex) == EnumOutputMode.Export) {
            ++nextIndex;
        }
        if (nextIndex >= EnumOutputMode.values().length) {
            nextIndex = 0;
        }
        EnumOutputMode newMode = EnumOutputMode.fromIndex(nextIndex);
        this.setOutputMode(slotIndex, newMode);
    }

    private void setOutputMode(int slotIndex, EnumOutputMode mode) {
        this.outputMode.get(slotIndex).set((Enum)mode);
        this.func_70296_d();
    }

    public InventoryItemStackHandler getInventoryItemStackHandler() {
        return this.inventoryItemStackHandler;
    }

    public InventoryGhostItemStackHandler getInventoryGhostItemStackHandler() {
        return this.inventoryGhostItemStackHandler;
    }

    public void setInventoryLocked(boolean locked) {
        this.inventoryLocked.set(locked);
        this.func_70296_d();
    }

    public boolean isInventoryLocked() {
        return this.inventoryLocked.get();
    }

    public FluidHandler getFluidHandler(int index) {
        return this.fluidHandlers[index];
    }

    public BucketItemStackHandler getBucketItemStackHandler() {
        return this.bucketItemStackHandler;
    }

    public void setFluidLocked(int index, boolean locked) {
        this.fluidLocked.get(index).set(locked);
        if (this.fluidHandlers[index].updateMemory()) {
            this.fluidHandlerTileData.get(index).setDirty(true);
        }
        this.func_70296_d();
        this.bucketUpdateRequired[index] = true;
    }

    public boolean isFluidLocked(int index) {
        return this.fluidLocked.get(index).get();
    }

    public EnumFluidMode getFluidMode(int slotIndex) {
        TileDataEnum<EnumFluidMode> tileData = this.fluidMode.get(slotIndex);
        return (EnumFluidMode)tileData.get();
    }

    public void cycleFluidMode(int slotIndex) {
        TileDataEnum<EnumFluidMode> tileData = this.fluidMode.get(slotIndex);
        EnumFluidMode enumOutputMode = (EnumFluidMode)tileData.get();
        int nextIndex = enumOutputMode.getIndex() + 1;
        if (nextIndex == EnumFluidMode.values().length) {
            nextIndex = 0;
        }
        EnumFluidMode newMode = EnumFluidMode.fromIndex(nextIndex);
        this.setFluidMode(slotIndex, newMode);
    }

    private void setFluidMode(int slotIndex, EnumFluidMode mode) {
        this.fluidMode.get(slotIndex).set((Enum)mode);
        this.func_70296_d();
        this.bucketUpdateRequired[slotIndex] = true;
    }

    public void destroyFluid(int index) {
        if (this.fluidHandlers[index].clearAll()) {
            this.fluidHandlerTileData.get(index).setDirty(true);
            this.bucketUpdateRequired[index] = true;
        }
    }

    public ToolStackHandler getToolStackHandler() {
        return this.toolStackHandler;
    }

    public ToolboxStackHandler getToolboxStackHandler() {
        return this.toolboxStackHandler;
    }

    public ToolUpgradeStackHandler getToolUpgradeStackHandler() {
        return this.toolUpgradeStackHandler;
    }

    public Stats getStats() {
        return this.stats;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return facing == EnumFacing.DOWN && (capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this.energyStorage);
            }
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)this.itemCapabilityWrapper;
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.fluidCapabilityWrapper;
            }
        }
        return null;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        TileDataBoolean tileData;
        int i;
        super.func_189515_b(compound);
        compound.func_74782_a("stats", (NBTBase)this.stats.serializeNBT());
        compound.func_74782_a("energyStorage", (NBTBase)this.energyStorage.serializeNBT());
        compound.func_74782_a("tableItemStackHandler", (NBTBase)this.tableItemStackHandler.serializeNBT());
        compound.func_74782_a("upgradeItemStackHandler", (NBTBase)this.upgradeItemStackHandler.serializeNBT());
        compound.func_74782_a("patternItemStackHandler", (NBTBase)this.patternItemStackHandler.serializeNBT());
        for (i = 0; i < this.outputItemStackHandler.length; ++i) {
            compound.func_74782_a("outputItemStackHandler" + i, (NBTBase)this.outputItemStackHandler[i].serializeNBT());
        }
        for (i = 0; i < this.outputMode.size(); ++i) {
            tileData = this.outputMode.get(i);
            EnumOutputMode enumOutputMode = (EnumOutputMode)tileData.get();
            compound.func_74768_a("outputMode" + i, enumOutputMode.getIndex());
        }
        compound.func_74782_a("inventoryItemStackHandler", (NBTBase)this.inventoryItemStackHandler.serializeNBT());
        compound.func_74782_a("inventoryGhostItemStackHandler", (NBTBase)this.inventoryGhostItemStackHandler.serializeNBT());
        compound.func_74757_a("inventoryLocked", this.inventoryLocked.get());
        for (i = 0; i < this.fluidHandlers.length; ++i) {
            compound.func_74782_a("fluidHandler" + i, (NBTBase)this.fluidHandlers[i].writeToNBT(new NBTTagCompound()));
        }
        compound.func_74782_a("bucketItemStackHandler", (NBTBase)this.bucketItemStackHandler.serializeNBT());
        for (i = 0; i < this.fluidMode.size(); ++i) {
            tileData = this.fluidMode.get(i);
            EnumFluidMode mode = (EnumFluidMode)tileData.get();
            compound.func_74768_a("fluidMode" + i, mode.getIndex());
        }
        for (i = 0; i < this.fluidLocked.size(); ++i) {
            tileData = this.fluidLocked.get(i);
            compound.func_74757_a("fluidLocked" + i, tileData.get());
        }
        compound.func_74782_a("toolStackHandler", (NBTBase)this.toolStackHandler.serializeNBT());
        compound.func_74782_a("toolboxStackHandler", (NBTBase)this.toolboxStackHandler.serializeNBT());
        compound.func_74782_a("toolUpgradeStackHandler", (NBTBase)this.toolUpgradeStackHandler.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        Object tileData;
        int index;
        int i;
        super.func_145839_a(compound);
        this.stats.deserializeNBT(compound.func_74775_l("stats"));
        this.energyStorage.setCapacity((int)((float)ModuleAutomatorConfig.MECHANICAL_ARTISAN.RF_CAPACITY * this.stats.getEnergyCapacity().get()));
        this.energyStorage.deserializeNBT(compound.func_74775_l("energyStorage"));
        this.tableItemStackHandler.deserializeNBT(compound.func_74775_l("tableItemStackHandler"));
        this.upgradeItemStackHandler.deserializeNBT(compound.func_74775_l("upgradeItemStackHandler"));
        this.patternItemStackHandler.deserializeNBT(compound.func_74775_l("patternItemStackHandler"));
        for (i = 0; i < this.outputItemStackHandler.length; ++i) {
            this.outputItemStackHandler[i].deserializeNBT(compound.func_74775_l("outputItemStackHandler" + i));
        }
        for (i = 0; i < this.outputMode.size(); ++i) {
            index = compound.func_74762_e("outputMode" + i);
            EnumOutputMode value = EnumOutputMode.fromIndex(index);
            tileData = this.outputMode.get(i);
            tileData.set((Enum)value);
        }
        this.inventoryItemStackHandler.deserializeNBT(compound.func_74775_l("inventoryItemStackHandler"));
        this.inventoryGhostItemStackHandler.deserializeNBT(compound.func_74775_l("inventoryGhostItemStackHandler"));
        this.inventoryLocked.set(compound.func_74767_n("inventoryLocked"));
        for (i = 0; i < this.fluidHandlers.length; ++i) {
            this.fluidHandlers[i].readFromNBT(compound.func_74775_l("fluidHandler" + i));
            this.fluidHandlers[i].setCapacity((int)((float)ModuleAutomatorConfig.MECHANICAL_ARTISAN.FLUID_CAPACITY * this.stats.getFluidCapacity().get()));
        }
        this.bucketItemStackHandler.deserializeNBT(compound.func_74775_l("bucketItemStackHandler"));
        for (i = 0; i < this.fluidMode.size(); ++i) {
            index = compound.func_74762_e("fluidMode" + i);
            EnumFluidMode mode = EnumFluidMode.fromIndex(index);
            tileData = this.fluidMode.get(i);
            tileData.set((Enum)mode);
        }
        for (i = 0; i < this.fluidLocked.size(); ++i) {
            boolean locked = compound.func_74767_n("fluidLocked" + i);
            TileDataBoolean tileData2 = this.fluidLocked.get(i);
            tileData2.set(locked);
        }
        this.toolStackHandler.deserializeNBT(compound.func_74775_l("toolStackHandler"));
        this.toolboxStackHandler.deserializeNBT(compound.func_74775_l("toolboxStackHandler"));
        this.toolUpgradeStackHandler.deserializeNBT(compound.func_74775_l("toolUpgradeStackHandler"));
    }

    public AutomatorContainer getContainer(InventoryPlayer inventoryPlayer, World world, IBlockState state, BlockPos pos) {
        return new AutomatorContainer(inventoryPlayer, world, this);
    }

    @SideOnly(value=Side.CLIENT)
    public AutomatorGuiContainer getGuiContainer(InventoryPlayer inventoryPlayer, World world, IBlockState state, BlockPos pos) {
        return new AutomatorGuiContainer(this, this.getContainer(inventoryPlayer, world, state, pos), 176, 190);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.tickCounter = this.tableItemStackHandler.getStackInSlot(0).func_190926_b() || this.energyStorage.getEnergyStored() == 0 ? 0.0f : (this.tickCounter += this.stats.speed.get());
        if (this.tickCounter >= (float)ModuleAutomatorConfig.MECHANICAL_ARTISAN.TICKS_PER_CRAFT) {
            this.tickCounter = 0.0f;
            this.doCrafting();
            this.repairTools();
        }
        this.updateOutputStacks();
        this.updateBuckets();
        this.exportItems();
        this.importItems();
        this.importFluids();
        this.progress.set(this.tickCounter / (float)ModuleAutomatorConfig.MECHANICAL_ARTISAN.TICKS_PER_CRAFT);
    }

    private void repairTools() {
        if (this.toolboxStackHandler.getStackInSlot(0).func_190926_b()) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            float durabilityRepairPercentage;
            NBTTagCompound toolUpgradeTag;
            ItemStack upgradeStack = this.toolUpgradeStackHandler.getStackInSlot(i);
            if (upgradeStack.func_190926_b() || (toolUpgradeTag = ItemUpgrade.getToolUpgradeTag(upgradeStack)) == null || toolUpgradeTag.func_186856_d() == 0 || (durabilityRepairPercentage = MathHelper.func_76131_a((float)toolUpgradeTag.func_74760_g("DurabilityRepaired"), (float)0.0f, (float)1.0f)) == 0.0f) continue;
            float energyUsageModifier = Math.max(-1.0f, toolUpgradeTag.func_74760_g("EnergyUsage"));
            this.repairTool(this.toolStackHandler, i, durabilityRepairPercentage, energyUsageModifier);
            this.repairTool(this.toolStackHandler, i + 6, durabilityRepairPercentage, energyUsageModifier);
        }
    }

    private void repairTool(ToolStackHandler stackHandler, int slot, float durabilityRepairPercentage, float energyUsageModifier) {
        ItemStack toolStack = stackHandler.getStackInSlot(slot);
        if (toolStack.func_190926_b() || toolStack.func_77952_i() == 0 || !toolStack.func_77973_b().isRepairable()) {
            return;
        }
        int durabilityToRepair = (int)(durabilityRepairPercentage * (float)toolStack.func_77958_k());
        if (durabilityToRepair > toolStack.func_77952_i()) {
            return;
        }
        int energyToUse = (int)((1.0f + energyUsageModifier) * (float)durabilityToRepair);
        if (this.getEnergyAmount() < energyToUse) {
            return;
        }
        for (int i = 0; i < this.inventoryItemStackHandler.getSlots(); ++i) {
            ItemStack repairMaterial = this.inventoryItemStackHandler.getStackInSlot(i);
            if (repairMaterial.func_190926_b() || !toolStack.func_77973_b().func_82789_a(toolStack, repairMaterial)) continue;
            ItemStack copy = toolStack.func_77946_l();
            copy.func_77964_b(Math.max(0, toolStack.func_77952_i() - durabilityToRepair));
            stackHandler.setStackInSlot(slot, copy);
            this.energyStorage.extractEnergy(energyToUse, false);
            this.inventoryItemStackHandler.extractItem(i, 1, false);
            break;
        }
    }

    private void importFluids() {
        BlockPos down;
        TileEntity tileEntityDown;
        if (!this.stats.getAutoImportFluids().get()) {
            return;
        }
        ++this.autoImportFluidsTickCount;
        if (this.autoImportFluidsTickCount < 20) {
            return;
        }
        this.autoImportFluidsTickCount = 0;
        IFluidHandler localFluidHandler = (IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
        if (localFluidHandler == null) {
            return;
        }
        block0: for (int j = 1; j < this.func_174877_v().func_177956_o() && (tileEntityDown = this.field_145850_b.func_175625_s(down = this.func_174877_v().func_177979_c(j))) instanceof ITileAutomatorBlock; ++j) {
            for (int i = 0; i < EnumFacing.field_176754_o.length; ++i) {
                int fill;
                FluidStack drain;
                IFluidHandler otherFluidHandler;
                TileEntity tileEntity = this.field_145850_b.func_175625_s(down.func_177972_a(EnumFacing.field_176754_o[i]));
                if (tileEntity == null || (otherFluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_176754_o[i].func_176734_d())) == null || (drain = otherFluidHandler.drain(1000, false)) == null || drain.amount == 0 || (fill = localFluidHandler.fill(drain, true)) == 0) continue;
                otherFluidHandler.drain(fill, true);
                break block0;
            }
        }
    }

    private void importItems() {
        BlockPos down;
        TileEntity tileEntityDown;
        if (!this.stats.getAutoImportItems().get()) {
            return;
        }
        ++this.autoImportItemsTickCount;
        if (this.autoImportItemsTickCount < 20) {
            return;
        }
        this.autoImportItemsTickCount = 0;
        IItemHandler localItemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        if (localItemHandler == null) {
            return;
        }
        block0: for (int j = 1; j < this.func_174877_v().func_177956_o() && (tileEntityDown = this.field_145850_b.func_175625_s(down = this.func_174877_v().func_177979_c(j))) instanceof ITileAutomatorBlock; ++j) {
            for (int i = 0; i < EnumFacing.field_176754_o.length; ++i) {
                IItemHandler otherItemHandler;
                TileEntity tileEntity = this.field_145850_b.func_175625_s(down.func_177972_a(EnumFacing.field_176754_o[i]));
                if (tileEntity == null || (otherItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_176754_o[i].func_176734_d())) == null) continue;
                for (int k = 0; k < otherItemHandler.getSlots(); ++k) {
                    ItemStack otherStackInSlotCopy = otherItemHandler.extractItem(k, otherItemHandler.getStackInSlot(k).func_190916_E(), true);
                    if (otherStackInSlotCopy.func_190926_b()) continue;
                    int otherStackCount = otherStackInSlotCopy.func_190916_E();
                    ItemStack itemStackToInsert = localItemHandler.insertItem(0, otherStackInSlotCopy, false);
                    for (int l = 1; l < localItemHandler.getSlots() && !itemStackToInsert.func_190926_b(); ++l) {
                        itemStackToInsert = localItemHandler.insertItem(l, itemStackToInsert, false);
                    }
                    if (otherStackCount == itemStackToInsert.func_190916_E()) continue;
                    otherItemHandler.extractItem(k, otherStackCount - itemStackToInsert.func_190916_E(), false);
                    break block0;
                }
            }
        }
    }

    private void exportItems() {
        block0: for (int i = 0; i < this.outputItemStackHandler.length; ++i) {
            BlockPos down;
            TileEntity tileEntityDown;
            if (this.outputMode.get(i).get() != EnumOutputMode.Export) continue;
            ItemStack stackToExport = this.outputItemStackHandler[i].getStackInSlot(0);
            for (int l = 1; l < this.func_174877_v().func_177956_o() && (tileEntityDown = this.field_145850_b.func_175625_s(down = this.func_174877_v().func_177979_c(l))) instanceof ITileAutomatorBlock; ++l) {
                for (int j = 0; j < EnumFacing.field_176754_o.length; ++j) {
                    IItemHandler otherItemHandler;
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(down.func_177972_a(EnumFacing.field_176754_o[j]));
                    if (tileEntity == null || (otherItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_176754_o[j].func_176734_d())) == null) continue;
                    for (int k = 0; k < otherItemHandler.getSlots(); ++k) {
                        ItemStack itemStack = otherItemHandler.insertItem(k, stackToExport, false);
                        if (itemStack.func_190916_E() == stackToExport.func_190916_E()) continue;
                        this.outputItemStackHandler[i].setStackInSlot(0, itemStack);
                        continue block0;
                    }
                }
            }
        }
    }

    private void doCrafting() {
        ItemStack tableStack = this.tableItemStackHandler.getStackInSlot(0);
        if (tableStack.func_190926_b()) {
            return;
        }
        Block blockFromItem = Block.func_149634_a((Item)tableStack.func_77973_b());
        if (!(blockFromItem instanceof BlockBase)) {
            return;
        }
        EnumTier tableTier = this.getTableTier(blockFromItem);
        if (tableTier == null) {
            return;
        }
        IBlockState blockState = blockFromItem.func_176203_a(tableStack.func_77960_j());
        EnumType tableType = (EnumType)blockState.func_177229_b(BlockBase.VARIANT);
        String typeName = tableType.func_176610_l();
        ItemStack[] tools = this.bakeTools(this.toolStackHandler);
        IToolHandler[] toolHandlers = this.getToolHandlers(tools);
        for (int i = 0; i < this.patternItemStackHandler.getSlots(); ++i) {
            IArtisanRecipe recipe;
            String recipeName;
            ItemStack patternStack = this.patternItemStackHandler.getStackInSlot(i);
            Item item = patternStack.func_77973_b();
            if (!(item instanceof ItemDesignPattern) || (recipeName = ((ItemDesignPattern)item).getRecipeName(patternStack)) == null || !recipeName.split(":")[0].equals(typeName) || (recipe = ArtisanAPI.getRecipe((String)recipeName)) == null || !recipe.matchTier(tableTier)) continue;
            int requiredEnergy = (int)((float)this.calculateRequiredRF(recipe) * this.stats.energyUsage.get());
            if (this.getEnergyAmount() < requiredEnergy || !ArtisanConfig.MODULE_WORKTABLES_CONFIG.enablePatternCreationForRecipesWithRequirements() && (!recipe.getRequirements().isEmpty() || recipe.getExperienceRequired() > 0) || !Util.hasIngredientsFor(recipe.getIngredientList(), recipe.getSecondaryIngredients(), this.inventoryItemStackHandler) || recipe.getFluidIngredient() != null && !Util.hasFluidsFor(recipe.getFluidIngredient(), this.fluidHandlers) || !recipe.matchesTools(tools, toolHandlers) || !this.hasOutputSpaceFor(i, recipe)) continue;
            this.energyStorage.extractEnergy(requiredEnergy, false);
            int tableWidth = tableTier == EnumTier.WORKSHOP ? 5 : 3;
            int tableHeight = tableTier == EnumTier.WORKSHOP ? 5 : 3;
            CraftingMatrixStackHandler craftingMatrixStackHandler = new CraftingMatrixStackHandler(tableWidth, tableHeight);
            Util.consumeIngredientsFor(recipe.getIngredientList(), this.inventoryItemStackHandler, (IItemHandler)craftingMatrixStackHandler);
            Util.consumeIngredientsFor(recipe.getSecondaryIngredients(), this.inventoryItemStackHandler, null);
            AutomatorCraftingContext automatorCraftingContext = new AutomatorCraftingContext(this.field_145850_b, (ICraftingMatrixStackHandler)craftingMatrixStackHandler, (IItemHandlerModifiable)this.toolStackHandler, (IItemHandler)this.inventoryItemStackHandler, this.fluidCapabilityWrapper, tableType, tableTier, this.field_174879_c);
            Util.consumeFluidsFor(recipe.getFluidIngredient(), this.fluidHandlers);
            try {
                ArrayList output = new ArrayList(1);
                recipe.doCraft((ICraftingContext)automatorCraftingContext, output);
                int matrixSlotCount = automatorCraftingContext.getCraftingMatrixHandler().getSlots();
                for (int j = 0; j < matrixSlotCount; ++j) {
                    ItemStack itemStack = automatorCraftingContext.getCraftingMatrixHandler().getStackInSlot(j);
                    if (itemStack.func_190926_b()) continue;
                    for (int k = 0; k < this.inventoryItemStackHandler.getSlots() && !(itemStack = this.itemCapabilityWrapper.insertItem(k, itemStack, false)).func_190926_b(); ++k) {
                    }
                    if (itemStack.func_190926_b()) continue;
                    StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c);
                }
                if (this.outputMode.get(i).get() == EnumOutputMode.Inventory) {
                    for (ItemStack itemStack : output) {
                        for (int j = 0; j < this.inventoryItemStackHandler.getSlots() && !(itemStack = this.itemCapabilityWrapper.insertItem(j, itemStack, false)).func_190926_b(); ++j) {
                        }
                    }
                } else {
                    for (ItemStack itemStack : output) {
                        this.getOutputItemStackHandler(i).insert(itemStack, false);
                    }
                }
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }

    private int calculateRequiredRF(IArtisanRecipe recipe) {
        int ingredientCount = 0;
        List ingredientList = recipe.getIngredientList();
        for (Object ingredient : ingredientList) {
            if (ingredient.isEmpty()) continue;
            ingredientCount += ingredient.getAmount();
        }
        List secondaryIngredients = recipe.getSecondaryIngredients();
        for (IArtisanIngredient secondaryIngredient : secondaryIngredients) {
            if (secondaryIngredient.isEmpty()) continue;
            ingredientCount += secondaryIngredient.getAmount();
        }
        int fluidMBCount = 0;
        if (recipe.getFluidIngredient() != null) {
            fluidMBCount = recipe.getFluidIngredient().amount;
        }
        return Math.max(0, ModuleAutomatorConfig.MECHANICAL_ARTISAN.RF_PER_CRAFT) + Math.max(0, ModuleAutomatorConfig.MECHANICAL_ARTISAN.RF_PER_ITEM_INGREDIENT) * ingredientCount + Math.max(0, ModuleAutomatorConfig.MECHANICAL_ARTISAN.RF_PER_MB_FLUID_INGREDIENT) * fluidMBCount;
    }

    private boolean hasOutputSpaceFor(int recipeSlotIndex, IArtisanRecipe recipe) {
        List outputWeightPairList = recipe.getOutputWeightPairList();
        ItemStack secondaryOutput = recipe.getSecondaryOutput().toItemStack();
        ItemStack tertiaryOutput = recipe.getTertiaryOutput().toItemStack();
        ItemStack quaternaryOutput = recipe.getQuaternaryOutput().toItemStack();
        for (OutputWeightPair pair : outputWeightPairList) {
            Object handler;
            ItemStack output = pair.getOutput().toItemStack();
            EnumOutputMode outputMode = this.getOutputMode(recipeSlotIndex);
            if (outputMode == EnumOutputMode.Inventory) {
                InventoryItemStackHandler handlerCopy = new InventoryItemStackHandler(this.getInventoryItemStackHandler());
                handler = new GhostItemInsertValidationItemHandlerWrapper((IItemHandler)handlerCopy, (IItemHandler)this.inventoryGhostItemStackHandler, () -> ((TileDataBoolean)this.inventoryLocked).get());
            } else {
                handler = new OutputItemStackHandler(this.getOutputItemStackHandler(recipeSlotIndex));
            }
            if (this.hasOutputSpaceFor((IItemHandler)handler, output, secondaryOutput, tertiaryOutput, quaternaryOutput)) continue;
            return false;
        }
        return true;
    }

    private boolean hasOutputSpaceFor(IItemHandler handler, ItemStack output, ItemStack secondaryOutput, ItemStack tertiaryOutput, ItemStack quaternaryOutput) {
        ItemStack copy;
        ItemStack insert;
        if (handler instanceof OutputItemStackHandler ? !(insert = ((OutputItemStackHandler)handler).insert(copy = output.func_77946_l(), true)).func_190926_b() : !this.testInsert(handler, output).func_190926_b()) {
            return false;
        }
        if (!secondaryOutput.func_190926_b() && !this.testInsert(handler, secondaryOutput).func_190926_b()) {
            return false;
        }
        if (!tertiaryOutput.func_190926_b() && !this.testInsert(handler, tertiaryOutput).func_190926_b()) {
            return false;
        }
        return quaternaryOutput.func_190926_b() || this.testInsert(handler, quaternaryOutput).func_190926_b();
    }

    private ItemStack testInsert(IItemHandler handler, ItemStack toInsert) {
        ItemStack remainingItems = toInsert.func_77946_l();
        for (int i = 0; i < handler.getSlots() && !(remainingItems = handler.insertItem(i, remainingItems, false)).func_190926_b(); ++i) {
        }
        return remainingItems;
    }

    private ItemStack[] bakeTools(ToolStackHandler toolStackHandler) {
        int slotCount = toolStackHandler.getSlots();
        ArrayList<ItemStack> tools = new ArrayList<ItemStack>(slotCount);
        for (int i = 0; i < slotCount; ++i) {
            ItemStack stackInSlot = toolStackHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            tools.add(stackInSlot);
        }
        return tools.toArray(new ItemStack[0]);
    }

    private IToolHandler[] getToolHandlers(ItemStack[] tools) {
        IToolHandler[] toolHandlers = new IToolHandler[tools.length];
        for (int i = 0; i < tools.length; ++i) {
            toolHandlers[i] = ArtisanToolHandlers.get((ItemStack)tools[i]);
        }
        return toolHandlers;
    }

    @Nullable
    private EnumTier getTableTier(Block block) {
        if (block instanceof BlockWorktable) {
            return EnumTier.WORKTABLE;
        }
        if (block instanceof BlockWorkstation) {
            return EnumTier.WORKSTATION;
        }
        if (block instanceof BlockWorkshop) {
            return EnumTier.WORKSHOP;
        }
        return null;
    }

    private void updateOutputStacks() {
        for (int i = 0; i < 9; ++i) {
            if (!this.outputDirty[i]) continue;
            this.outputItemStackHandler[i].settleStacks();
            this.outputDirty[i] = false;
        }
    }

    private void updateBuckets() {
        for (int i = 0; i < this.bucketUpdateRequired.length; ++i) {
            SoundEvent sound;
            FluidActionResult fluidActionResult;
            FluidStack fluid;
            int containerCapacity;
            IFluidHandlerItem capability;
            if (!this.bucketUpdateRequired[i]) continue;
            this.bucketUpdateRequired[i] = false;
            ItemStack container = this.bucketItemStackHandler.getStackInSlot(i);
            if (container.func_190926_b() || (capability = (IFluidHandlerItem)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null) continue;
            if (this.fluidMode.get(i).get() == EnumFluidMode.Drain && this.fluidHandlers[i].getFluidAmount() > 0) {
                containerCapacity = capability.getTankProperties()[0].getCapacity();
                fluid = this.fluidHandlers[i].getFluid() != null ? this.fluidHandlers[i].getFluid().copy() : null;
                fluidActionResult = FluidUtil.tryFillContainer((ItemStack)container, (IFluidHandler)this.fluidHandlers[i], (int)containerCapacity, null, (boolean)true);
                if (!fluidActionResult.success) continue;
                this.bucketItemStackHandler.setStackInSlot(i, fluidActionResult.result);
                if (fluid == null) continue;
                sound = fluid.getFluid().getFillSound(fluid);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                continue;
            }
            if (this.fluidMode.get(i).get() != EnumFluidMode.Fill || this.fluidHandlers[i].getFluidAmount() >= this.fluidHandlers[i].getCapacity()) continue;
            containerCapacity = capability.getTankProperties()[0].getCapacity();
            fluid = capability.drain(containerCapacity, false);
            fluid = fluid != null ? fluid.copy() : null;
            fluidActionResult = FluidUtil.tryEmptyContainer((ItemStack)container, (IFluidHandler)this.fluidHandlers[i], (int)containerCapacity, null, (boolean)true);
            if (!fluidActionResult.success) continue;
            this.bucketItemStackHandler.setStackInSlot(i, fluidActionResult.result);
            if (fluid == null) continue;
            sound = fluid.getFluid().getEmptySound(fluid);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onTileDataUpdate() {
        if (this.energyStorageData.isDirty()) {
            int currentEnergy = this.getEnergyAmount();
            if (this.previousEnergy == 0 && currentEnergy > 0 || this.previousEnergy > 0 && currentEnergy == 0) {
                BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b());
            }
            this.previousEnergy = currentEnergy;
        }
    }

    @Override
    public boolean isPowered() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    public static class Stats
    implements INBTSerializable<NBTTagCompound> {
        private final TileDataFloat speed = new TileDataFloat(1.0f);
        private final TileDataFloat energyUsage = new TileDataFloat(1.0f);
        private final TileDataFloat fluidCapacity = new TileDataFloat(1.0f);
        private final TileDataFloat energyCapacity = new TileDataFloat(1.0f);
        private final TileDataBoolean autoExportItems = new TileDataBoolean(false);
        private final TileDataBoolean autoImportItems = new TileDataBoolean(false);
        private final TileDataBoolean autoImportFluids = new TileDataBoolean(false);

        public TileDataFloat getSpeed() {
            return this.speed;
        }

        public TileDataFloat getEnergyUsage() {
            return this.energyUsage;
        }

        public TileDataFloat getFluidCapacity() {
            return this.fluidCapacity;
        }

        public TileDataFloat getEnergyCapacity() {
            return this.energyCapacity;
        }

        public TileDataBoolean getAutoExportItems() {
            return this.autoExportItems;
        }

        public TileDataBoolean getAutoImportItems() {
            return this.autoImportItems;
        }

        public TileDataBoolean getAutoImportFluids() {
            return this.autoImportFluids;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("Speed", this.speed.get());
            tag.func_74776_a("EnergyUsage", this.energyUsage.get());
            tag.func_74776_a("FluidCapacity", this.fluidCapacity.get());
            tag.func_74776_a("EnergyCapacity", this.energyCapacity.get());
            tag.func_74757_a("AutoExportItems", this.autoExportItems.get());
            tag.func_74757_a("AutoImportItems", this.autoImportItems.get());
            tag.func_74757_a("AutoImportFluids", this.autoImportFluids.get());
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            this.speed.set(tag.func_74760_g("Speed"));
            this.energyUsage.set(tag.func_74760_g("EnergyUsage"));
            this.fluidCapacity.set(tag.func_74760_g("FluidCapacity"));
            this.energyCapacity.set(tag.func_74760_g("EnergyCapacity"));
            this.autoExportItems.set(tag.func_74767_n("AutoExportItems"));
            this.autoImportItems.set(tag.func_74767_n("AutoImportItems"));
            this.autoImportFluids.set(tag.func_74767_n("AutoImportFluids"));
        }

        public void registerNetwork(List<ITileData> tileDataList) {
            tileDataList.add((ITileData)this.speed);
            tileDataList.add((ITileData)this.energyUsage);
            tileDataList.add((ITileData)this.fluidCapacity);
            tileDataList.add((ITileData)this.energyCapacity);
            tileDataList.add((ITileData)this.autoExportItems);
            tileDataList.add((ITileData)this.autoImportItems);
            tileDataList.add((ITileData)this.autoImportFluids);
        }

        public void calculate(UpgradeItemStackHandler stackHandler) {
            this.speed.set(1.0f);
            this.energyUsage.set(1.0f);
            this.fluidCapacity.set(1.0f);
            this.energyCapacity.set(1.0f);
            this.autoExportItems.set(false);
            this.autoImportItems.set(false);
            this.autoImportFluids.set(false);
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                NBTTagCompound upgradeTag;
                ItemStack stackInSlot = stackHandler.getStackInSlot(i);
                if (stackInSlot.func_190926_b() || (upgradeTag = ItemUpgrade.getUpgradeTag(stackInSlot)) == null) continue;
                this.speed.set(this.speed.get() + upgradeTag.func_74760_g("Speed"));
                this.energyUsage.set(this.energyUsage.get() + upgradeTag.func_74760_g("EnergyUsage"));
                this.fluidCapacity.set(this.fluidCapacity.get() + upgradeTag.func_74760_g("FluidCapacity"));
                this.energyCapacity.set(this.energyCapacity.get() + upgradeTag.func_74760_g("EnergyCapacity"));
                if (upgradeTag.func_74767_n("AutoExportItems")) {
                    this.autoExportItems.set(true);
                }
                if (upgradeTag.func_74767_n("AutoImportItems")) {
                    this.autoImportItems.set(true);
                }
                if (!upgradeTag.func_74767_n("AutoImportFluids")) continue;
                this.autoImportFluids.set(true);
            }
            this.speed.set(Math.max(0.0f, this.speed.get()));
            this.energyUsage.set(Math.max(0.0f, this.energyUsage.get()));
            this.fluidCapacity.set(Math.max(0.0f, this.fluidCapacity.get()));
            this.energyCapacity.set(Math.max(0.0f, this.energyCapacity.get()));
        }
    }

    public static enum EnumFluidMode {
        Fill(0),
        Drain(1);

        private static final EnumFluidMode[] INDEX_LOOKUP;
        private final int index;

        private EnumFluidMode(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumFluidMode fromIndex(int index) {
            return INDEX_LOOKUP[index];
        }

        static {
            INDEX_LOOKUP = (EnumFluidMode[])Stream.of(EnumFluidMode.values()).sorted(Comparator.comparing(EnumFluidMode::getIndex)).toArray(EnumFluidMode[]::new);
        }
    }

    public static enum EnumOutputMode {
        Keep(0),
        Manual(1),
        Inventory(2),
        Export(3);

        private static final EnumOutputMode[] INDEX_LOOKUP;
        private final int index;

        private EnumOutputMode(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumOutputMode fromIndex(int index) {
            return INDEX_LOOKUP[index];
        }

        static {
            INDEX_LOOKUP = (EnumOutputMode[])Stream.of(EnumOutputMode.values()).sorted(Comparator.comparing(EnumOutputMode::getIndex)).toArray(EnumOutputMode[]::new);
        }
    }
}

