/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.gui.element;

import com.codetaylor.mc.artisanautomation.modules.automator.ModuleAutomator;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.AutomatorContainer;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.AutomatorGuiContainer;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorFluidDestroy;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.fluid.data.FluidHandler;
import com.codetaylor.mc.athenaeum.gui.GuiContainerBase;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementFluidTankHorizontal;
import com.codetaylor.mc.athenaeum.gui.element.IGuiElementClickable;
import com.codetaylor.mc.athenaeum.gui.element.IGuiElementTooltipExtendedProvider;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiElementFluidTank
extends GuiElementFluidTankHorizontal
implements IGuiElementTooltipExtendedProvider,
IGuiElementClickable {
    private final BlockPos tilePos;
    private final int fluidIndex;
    private final AutomatorGuiContainer guiContainer;
    private final FluidHandler fluidHandler;

    public GuiElementFluidTank(BlockPos tilePos, int fluidIndex, AutomatorGuiContainer guiBase, FluidHandler fluidHandler, int elementX, int elementY, int elementWidth, int elementHeight) {
        super((GuiContainerBase)guiBase, (FluidTank)fluidHandler, elementX, elementY, elementWidth, elementHeight);
        this.tilePos = tilePos;
        this.fluidIndex = fluidIndex;
        this.guiContainer = guiBase;
        this.fluidHandler = fluidHandler;
    }

    public boolean elementIsVisible(int mouseX, int mouseY) {
        return this.guiContainer.getContainerState() == AutomatorContainer.EnumState.Fluid;
    }

    public void elementClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && GuiScreen.func_146272_n() && (this.fluidHandler.getFluid() != null || this.fluidHandler.getMemoryStack() != null)) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            world.func_184156_a(this.tilePos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            ModuleAutomator.PACKET_SERVICE.sendToServer((IMessage)new CSPacketAutomatorFluidDestroy(this.tilePos, this.fluidIndex));
        }
    }

    public List<String> tooltipTextGet(List<String> tooltip) {
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (fluidStack == null || this.fluidTank.getFluidAmount() == 0) {
            tooltip.add(I18n.func_135052_a((String)"gui.artisanworktables.tooltip.fluid.empty", (Object[])new Object[0]));
            tooltip.add("" + TextFormatting.GRAY + "0 / " + this.fluidTank.getCapacity() + " mB");
        } else {
            Fluid fluid = fluidStack.getFluid();
            tooltip.add(fluid.getLocalizedName(fluidStack));
            tooltip.add("" + TextFormatting.GRAY + this.fluidTank.getFluidAmount() + " / " + this.fluidTank.getCapacity() + " mB");
        }
        return tooltip;
    }

    public List<String> tooltipTextExtendedGet(List<String> tooltip) {
        FluidStack fluidStack = this.fluidHandler.getMemoryStack();
        if (fluidStack != null && this.fluidHandler.isLocked()) {
            Fluid fluid = fluidStack.getFluid();
            tooltip.add(TextFormatting.DARK_RED + "Locked: " + fluid.getLocalizedName(fluidStack));
        } else if (!this.fluidHandler.isLocked()) {
            tooltip.add(TextFormatting.DARK_GREEN + "Unlocked");
        } else if (fluidStack == null) {
            tooltip.add(TextFormatting.DARK_RED + "Locked: " + I18n.func_135052_a((String)"gui.artisanworktables.tooltip.fluid.empty", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"gui.artisanworktables.tooltip.fluid.destroy", (Object[])new Object[]{TextFormatting.DARK_GRAY, TextFormatting.DARK_GRAY}));
        return tooltip;
    }
}

