/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.gui.element;

import com.codetaylor.mc.artisanautomation.modules.automator.ModuleAutomator;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.AutomatorContainer;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementPanelButtonBase;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorOutputModeChange;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.TileAutomator;
import com.codetaylor.mc.athenaeum.gui.GuiContainerBase;
import com.codetaylor.mc.athenaeum.gui.Texture;
import com.codetaylor.mc.athenaeum.gui.element.IGuiElementTooltipExtendedProvider;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiElementButtonOutputMode
extends GuiElementPanelButtonBase
implements IGuiElementTooltipExtendedProvider {
    private final BlockPos blockPos;
    private final int slotIndex;
    private final Supplier<TileAutomator.EnumOutputMode> currentOutputMode;

    public GuiElementButtonOutputMode(BlockPos blockPos, int slotIndex, Supplier<TileAutomator.EnumOutputMode> currentOutputMode, Supplier<AutomatorContainer.EnumState> currentState, GuiContainerBase guiBase, Texture[] textures, int elementX, int elementY, int elementWidth, int elementHeight) {
        super(currentState, AutomatorContainer.EnumState.Pattern, guiBase, textures, elementX, elementY, elementWidth, elementHeight);
        this.blockPos = blockPos;
        this.slotIndex = slotIndex;
        this.currentOutputMode = currentOutputMode;
    }

    protected int textureIndexGet(int mouseX, int mouseY) {
        TileAutomator.EnumOutputMode outputMode = this.currentOutputMode.get();
        if (this.elementIsMouseInside(mouseX, mouseY)) {
            return outputMode.getIndex() + this.textures.length / 2;
        }
        return outputMode.getIndex();
    }

    public void elementClicked(int mouseX, int mouseY, int mouseButton) {
        super.elementClicked(mouseX, mouseY, mouseButton);
        ModuleAutomator.PACKET_SERVICE.sendToServer((IMessage)new CSPacketAutomatorOutputModeChange(this.blockPos, this.slotIndex));
    }

    public List<String> tooltipTextGet(List<String> tooltip) {
        TileAutomator.EnumOutputMode outputMode = this.currentOutputMode.get();
        String modeKey = "ERROR";
        switch (outputMode) {
            case Keep: {
                modeKey = "tooltip.artisanautomation.automator.output.slot.mode.keep";
                break;
            }
            case Manual: {
                modeKey = "tooltip.artisanautomation.automator.output.slot.mode.manual";
                break;
            }
            case Inventory: {
                modeKey = "tooltip.artisanautomation.automator.output.slot.mode.inventory";
                break;
            }
            case Export: {
                modeKey = "tooltip.artisanautomation.automator.output.slot.mode.export";
            }
        }
        tooltip.add(I18n.func_135052_a((String)"tooltip.artisanautomation.automator.output.slot.mode", (Object[])new Object[]{I18n.func_135052_a((String)modeKey, (Object[])new Object[0])}));
        return tooltip;
    }

    public List<String> tooltipTextExtendedGet(List<String> tooltip) {
        TileAutomator.EnumOutputMode outputMode = this.currentOutputMode.get();
        String infoKey = "ERROR";
        switch (outputMode) {
            case Keep: {
                infoKey = "tooltip.artisanautomation.automator.output.slot.mode.keep.info";
                break;
            }
            case Manual: {
                infoKey = "tooltip.artisanautomation.automator.output.slot.mode.manual.info";
                break;
            }
            case Inventory: {
                infoKey = "tooltip.artisanautomation.automator.output.slot.mode.inventory.info";
                break;
            }
            case Export: {
                infoKey = "tooltip.artisanautomation.automator.output.slot.mode.export.info";
            }
        }
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)infoKey, (Object[])new Object[0]));
        return tooltip;
    }
}

