/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.gui.element;

import com.codetaylor.mc.artisanautomation.modules.automator.ModuleAutomator;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.AutomatorContainer;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementPanelButtonBase;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorFluidModeChange;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.TileAutomator;
import com.codetaylor.mc.athenaeum.gui.GuiContainerBase;
import com.codetaylor.mc.athenaeum.gui.Texture;
import com.codetaylor.mc.athenaeum.gui.element.IGuiElementTooltipExtendedProvider;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiElementButtonFluidMode
extends GuiElementPanelButtonBase
implements IGuiElementTooltipExtendedProvider {
    private final BlockPos tilePos;
    private final int slotIndex;
    private final Supplier<TileAutomator.EnumFluidMode> currentFluidMode;

    public GuiElementButtonFluidMode(BlockPos tilePos, int slotIndex, Supplier<TileAutomator.EnumFluidMode> currentFluidMode, Supplier<AutomatorContainer.EnumState> currentState, GuiContainerBase guiBase, Texture[] textures, int elementX, int elementY) {
        super(currentState, AutomatorContainer.EnumState.Fluid, guiBase, textures, elementX, elementY, 16, 16);
        this.tilePos = tilePos;
        this.slotIndex = slotIndex;
        this.currentFluidMode = currentFluidMode;
    }

    protected int textureIndexGet(int mouseX, int mouseY) {
        TileAutomator.EnumFluidMode mode = this.currentFluidMode.get();
        if (this.elementIsMouseInside(mouseX, mouseY)) {
            return mode.getIndex() + this.textures.length / 2;
        }
        return mode.getIndex();
    }

    public void elementClicked(int mouseX, int mouseY, int mouseButton) {
        super.elementClicked(mouseX, mouseY, mouseButton);
        ModuleAutomator.PACKET_SERVICE.sendToServer((IMessage)new CSPacketAutomatorFluidModeChange(this.tilePos, this.slotIndex));
    }

    public List<String> tooltipTextGet(List<String> tooltip) {
        TileAutomator.EnumFluidMode mode = this.currentFluidMode.get();
        String modeKey = "ERROR";
        switch (mode) {
            case Fill: {
                modeKey = "tooltip.artisanautomation.automator.fluid.mode.fill";
                break;
            }
            case Drain: {
                modeKey = "tooltip.artisanautomation.automator.fluid.mode.drain";
            }
        }
        tooltip.add(I18n.func_135052_a((String)"tooltip.artisanautomation.automator.fluid.mode", (Object[])new Object[]{I18n.func_135052_a((String)modeKey, (Object[])new Object[0])}));
        return tooltip;
    }

    public List<String> tooltipTextExtendedGet(List<String> tooltip) {
        TileAutomator.EnumFluidMode mode = this.currentFluidMode.get();
        String infoKey = "ERROR";
        switch (mode) {
            case Fill: {
                infoKey = "tooltip.artisanautomation.automator.fluid.mode.fill.info";
                break;
            }
            case Drain: {
                infoKey = "tooltip.artisanautomation.automator.fluid.mode.drain.info";
            }
        }
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)infoKey, (Object[])new Object[0]));
        return tooltip;
    }
}

