/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.gui.element;

import com.codetaylor.mc.artisanautomation.modules.automator.ModuleAutomator;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.AutomatorContainer;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementPanelButtonBase;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorFluidLockModeChange;
import com.codetaylor.mc.artisanworktables.lib.IBooleanSupplier;
import com.codetaylor.mc.athenaeum.gui.GuiContainerBase;
import com.codetaylor.mc.athenaeum.gui.Texture;
import com.codetaylor.mc.athenaeum.gui.element.IGuiElementTooltipExtendedProvider;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiElementButtonFluidLockMode
extends GuiElementPanelButtonBase
implements IGuiElementTooltipExtendedProvider {
    private final int slotIndex;
    private final IBooleanSupplier currentLockedMode;
    private final BlockPos tilePos;

    public GuiElementButtonFluidLockMode(BlockPos tilePos, int slotIndex, IBooleanSupplier currentLockedMode, Supplier<AutomatorContainer.EnumState> currentState, GuiContainerBase guiBase, Texture[] textures, int elementX, int elementY) {
        super(currentState, AutomatorContainer.EnumState.Fluid, guiBase, textures, elementX, elementY, 16, 16);
        this.tilePos = tilePos;
        this.slotIndex = slotIndex;
        this.currentLockedMode = currentLockedMode;
    }

    protected int textureIndexGet(int mouseX, int mouseY) {
        boolean isLocked = this.currentLockedMode.get();
        if (this.elementIsMouseInside(mouseX, mouseY)) {
            return (isLocked ? 1 : 0) + this.textures.length / 2;
        }
        return isLocked ? 1 : 0;
    }

    public void elementClicked(int mouseX, int mouseY, int mouseButton) {
        super.elementClicked(mouseX, mouseY, mouseButton);
        ModuleAutomator.PACKET_SERVICE.sendToServer((IMessage)new CSPacketAutomatorFluidLockModeChange(this.tilePos, this.slotIndex));
    }

    public List<String> tooltipTextGet(List<String> tooltip) {
        boolean isLocked = this.currentLockedMode.get();
        String langKey = isLocked ? "tooltip.artisanautomation.automator.fluid.locked" : "tooltip.artisanautomation.automator.fluid.unlocked";
        tooltip.add(I18n.func_135052_a((String)langKey, (Object[])new Object[0]));
        return tooltip;
    }

    public List<String> tooltipTextExtendedGet(List<String> tooltip) {
        boolean isLocked = this.currentLockedMode.get();
        String langKey = isLocked ? "tooltip.artisanautomation.automator.fluid.locked.info" : "tooltip.artisanautomation.automator.fluid.unlocked.info";
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)langKey, (Object[])new Object[0]));
        return tooltip;
    }
}

