/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.gui;

import com.codetaylor.mc.artisanautomation.modules.automator.TooltipUtil;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.AutomatorContainer;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementAutomatorPanel;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementButtonAutomatorTab;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementButtonAutomatorTabSelected;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementButtonFluidLockMode;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementButtonFluidMode;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementButtonInventoryLockMode;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementButtonOutputMode;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementDurationBar;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementFluidTank;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementInventoryGhostItem;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementPowerBar;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.element.GuiElementToolCap;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.slot.InventorySlot;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.slot.TableSlot;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.TileAutomator;
import com.codetaylor.mc.athenaeum.gui.ContainerBase;
import com.codetaylor.mc.athenaeum.gui.GuiContainerBase;
import com.codetaylor.mc.athenaeum.gui.GuiHelper;
import com.codetaylor.mc.athenaeum.gui.Texture;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementBase;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementTextureRectangle;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementTitle;
import com.codetaylor.mc.athenaeum.packer.PackAPI;
import com.codetaylor.mc.athenaeum.packer.PackedData;
import com.codetaylor.mc.athenaeum.util.TooltipHelper;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Keyboard;

public class AutomatorGuiContainer
extends GuiContainerBase {
    public static final int TEXT_OUTLINE_COLOR = new Color(133, 90, 49).getRGB();
    private final TileAutomator tile;
    private final AutomatorContainer container;

    public AutomatorGuiContainer(TileAutomator tile, AutomatorContainer container, int width, int height) {
        super((ContainerBase)container, width, height);
        this.tile = tile;
        this.container = container;
        this.createBackgroundElement();
        this.createContainerTextElements();
        this.createDeselectedTabElements();
        this.createPanelElement();
        this.createPowerPanelElements();
        this.createPatternPanelElements();
        this.createInventoryPanelElements();
        this.createFluidPanelElements();
        this.createToolPanelElements();
        this.createSelectedTabElements();
    }

    private void createToolPanelElements() {
        for (int i = 0; i < 6; ++i) {
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementToolCap(this::getContainerState, AutomatorContainer.EnumState.Tool, () -> !this.tile.getToolboxStackHandler().getStackInSlot(0).func_190926_b(), this, new Texture[]{this.getTexture("tool-upgrade-cap")}, 8 + i * 18, 56)});
        }
    }

    private void createFluidPanelElements() {
        for (int i = 0; i < 3; ++i) {
            int fluidIndex = i;
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementFluidTank(this.tile.func_174877_v(), fluidIndex, this, this.tile.getFluidHandler(i), 64, 39 + 18 * i, 102, 14)});
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonFluidLockMode(this.tile.func_174877_v(), fluidIndex, () -> this.tile.isFluidLocked(fluidIndex), this::getContainerState, this, new Texture[]{this.getTexture("inventory-button-lock-unlocked"), this.getTexture("inventory-button-lock-locked"), this.getTexture("inventory-button-lock-unlocked-hovered"), this.getTexture("inventory-button-lock-locked-hovered")}, 44, 38 + i * 18)});
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonFluidMode(this.tile.func_174877_v(), fluidIndex, () -> this.tile.getFluidMode(fluidIndex), this::getContainerState, this, new Texture[]{this.getTexture("fluid-button-mode-fill"), this.getTexture("fluid-button-mode-drain"), this.getTexture("fluid-button-mode-fill-hovered"), this.getTexture("fluid-button-mode-drain-hovered")}, 26, 38 + i * 18)});
        }
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTextureRectangle(this, this.getTexture("panel-fluid-glass"), 62, 38, 106, 52){

            public boolean elementIsVisible(int mouseX, int mouseY) {
                AutomatorContainer.EnumState containerState = AutomatorGuiContainer.this.getContainerState();
                return containerState == AutomatorContainer.EnumState.Fluid;
            }
        }});
    }

    private void createInventoryPanelElements() {
        int i = 0;
        while (i < 26) {
            int x = i % 9;
            int y = i / 9;
            int slotIndex = i++;
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementInventoryGhostItem(slotIndex, this.tile.func_174877_v(), this::getContainerState, () -> this.tile.getInventoryGhostItemStackHandler().getStackInSlot(slotIndex), this, 8 + x * 18, 38 + y * 18)});
        }
        GuiElementBase[] guiElementBaseArray = new GuiElementBase[1];
        guiElementBaseArray[0] = new GuiElementButtonInventoryLockMode(this.tile.func_174877_v(), this.tile::isInventoryLocked, this::getContainerState, this, new Texture[]{this.getTexture("inventory-button-lock-unlocked"), this.getTexture("inventory-button-lock-locked"), this.getTexture("inventory-button-lock-unlocked-hovered"), this.getTexture("inventory-button-lock-locked-hovered")}, 152, 74);
        this.guiContainerElementAdd(guiElementBaseArray);
    }

    private void createPatternPanelElements() {
        for (int i = 0; i < 9; ++i) {
            int slotIndex = i;
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonOutputMode(this.tile.func_174877_v(), slotIndex, () -> this.tile.getOutputMode(slotIndex), this::getContainerState, this, new Texture[]{this.getTexture("pattern-button-keep"), this.getTexture("pattern-button-manual"), this.getTexture("pattern-button-inventory"), this.getTexture("pattern-button-export"), this.getTexture("pattern-button-keep-hovered"), this.getTexture("pattern-button-manual-hovered"), this.getTexture("pattern-button-inventory-hovered"), this.getTexture("pattern-button-export-hovered")}, 8 + 18 * i, 74, 16, 16)});
        }
    }

    private void createSelectedTabElements() {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTabSelected(AutomatorContainer.EnumState.Gear, this, this.getTexture("tab-gear-selected"), 12, 17, 20, 19)});
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTabSelected(AutomatorContainer.EnumState.Pattern, this, this.getTexture("tab-pattern-selected"), 32, 17, 20, 19)});
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTabSelected(AutomatorContainer.EnumState.Inventory, this, this.getTexture("tab-inventory-selected"), 52, 17, 20, 19)});
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTabSelected(AutomatorContainer.EnumState.Fluid, this, this.getTexture("tab-fluid-selected"), 72, 17, 20, 19)});
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTabSelected(AutomatorContainer.EnumState.Tool, this, this.getTexture("tab-tool-selected"), 92, 17, 20, 19)});
    }

    private void createPowerPanelElements() {
        GuiElementBase[] guiElementBaseArray = new GuiElementBase[1];
        guiElementBaseArray[0] = new GuiElementPowerBar(this.tile::getEnergyAmount, this.tile::getEnergyCapacity, this, this.getTexture("power-power-bar-lit"), 74, 49, 83, 7);
        this.guiContainerElementAdd(guiElementBaseArray);
        GuiElementBase[] guiElementBaseArray2 = new GuiElementBase[1];
        guiElementBaseArray2[0] = new GuiElementDurationBar(this.tile::getProgress, this, this.getTexture("power-duration-bar-lit"), 74, 57, 83, 4);
        this.guiContainerElementAdd(guiElementBaseArray2);
    }

    private void createPanelElement() {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementAutomatorPanel(this, new Texture[]{this.getTexture("background#panel-power"), this.getTexture("panel-pattern"), this.getTexture("panel-inventory"), this.getTexture("panel-fluid"), this.getTexture("panel-tool")}, 5, 35, 166, 58)});
    }

    private void createBackgroundElement() {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTextureRectangle((GuiContainerBase)this, this.getTexture("background#all"), 0, 0, this.field_146999_f, this.field_147000_g)});
    }

    private void createContainerTextElements() {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTitle((GuiContainerBase)this, "tile.artisanautomation.automator.name", 8, 7)});
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTitle((GuiContainerBase)this, "container.inventory", 8, this.field_147000_g - 93)});
    }

    private void createDeselectedTabElements() {
        Texture texture = this.getTexture("tab-gear-dark");
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTab(AutomatorContainer.EnumState.Gear, this, texture, 12, 21, 20, 18)});
        texture = this.getTexture("tab-pattern-dark");
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTab(AutomatorContainer.EnumState.Pattern, this, texture, 32, 21, 20, 18)});
        texture = this.getTexture("tab-inventory-dark");
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTab(AutomatorContainer.EnumState.Inventory, this, texture, 52, 21, 20, 18)});
        texture = this.getTexture("tab-fluid-dark");
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTab(AutomatorContainer.EnumState.Fluid, this, texture, 72, 21, 20, 18)});
        texture = this.getTexture("tab-tool-dark");
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonAutomatorTab(AutomatorContainer.EnumState.Tool, this, texture, 92, 21, 20, 18)});
    }

    public AutomatorContainer.EnumState getContainerState() {
        return this.container.getState();
    }

    public void drawString(String translateKey, int x, int y) {
        FontRenderer fontRenderer = this.field_146289_q;
        GuiHelper.drawStringOutlined((String)translateKey, (int)x, (int)y, (FontRenderer)fontRenderer, (int)TEXT_OUTLINE_COLOR);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int x, int y) {
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            Slot slotUnderMouse = this.getSlotUnderMouse();
            if (slotUnderMouse instanceof InventorySlot && !slotUnderMouse.func_75216_d()) {
                this.renderInventoryTooltip(x, y, ((InventorySlot)slotUnderMouse).getIndex());
            } else if (slotUnderMouse != null && slotUnderMouse.func_75216_d()) {
                this.func_146285_a(slotUnderMouse.func_75211_c(), x, y);
            }
        }
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        Slot slotUnderMouse = this.getSlotUnderMouse();
        if (slotUnderMouse instanceof TableSlot) {
            this.renderTableTooltip(stack, x, y);
        } else {
            super.func_146285_a(stack, x, y);
        }
    }

    private void renderInventoryTooltip(int x, int y, int index) {
        ItemStack ghostStack = this.tile.getInventoryGhostItemStackHandler().getStackInSlot(index);
        if (!ghostStack.func_190926_b() && this.tile.getInventoryItemStackHandler().getStackInSlot(index).func_190926_b()) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(ghostStack.func_77953_t().field_77937_e + ghostStack.func_82833_r());
            tooltip.add(I18n.func_135052_a((String)"tooltip.artisanautomation.automator.clear.ghost.item", (Object[])new Object[]{TextFormatting.DARK_GRAY, TextFormatting.DARK_GRAY}));
            FontRenderer font = ghostStack.func_77973_b().getFontRenderer(ghostStack);
            this.drawHoveringText(tooltip, x, y, font == null ? this.field_146289_q : font);
            GuiUtils.postItemToolTip();
        }
    }

    private void renderTableTooltip(ItemStack stack, int x, int y) {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(stack.func_77953_t().field_77937_e + stack.func_82833_r());
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            TileAutomator.Stats stats = this.tile.getStats();
            int speedModifier = (int)(stats.getSpeed().get() * 100.0f);
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getSpeedString(speedModifier, false));
            int energyUsageModifier = (int)(stats.getEnergyUsage().get() * 100.0f);
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getEnergyUsageString(energyUsageModifier, false));
            int fluidCapacityModifier = (int)(stats.getFluidCapacity().get() * 100.0f);
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getFluidCapacityString(fluidCapacityModifier, false));
            int energyCapacityModifier = (int)(stats.getEnergyCapacity().get() * 100.0f);
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getEnergyCapacityString(energyCapacityModifier, false));
            boolean autoImportItems = stats.getAutoImportItems().get();
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getAutoImportItemsString(autoImportItems));
            boolean autoExportItems = stats.getAutoExportItems().get();
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getAutoExportItemsString(autoExportItems));
            boolean autoImportFluids = stats.getAutoImportFluids().get();
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getAutoImportFluidsString(autoImportFluids));
        } else {
            tooltip.add(TooltipHelper.tooltipHoldShiftStringGet());
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        this.drawHoveringText(tooltip, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    private Texture getTexture(String path) {
        PackedData.ImageData imageData = PackAPI.getImageData((ResourceLocation)new ResourceLocation("artisanautomation", path));
        ResourceLocation atlasResourceLocation = new ResourceLocation("artisanautomation", imageData.atlas);
        PackedData.AtlasData atlasData = PackAPI.getAtlasData((ResourceLocation)atlasResourceLocation);
        return new Texture(atlasResourceLocation, imageData.u, imageData.v, atlasData.width, atlasData.height);
    }
}

