/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.gui;

import com.codetaylor.mc.artisanautomation.modules.automator.gui.slot.InventorySlot;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.slot.OutputPanelSlot;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.slot.PanelSlot;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.slot.TableSlot;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.slot.ToolBoxPanelSlot;
import com.codetaylor.mc.artisanautomation.modules.automator.gui.slot.ToolUpgradePanelSlot;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.TileAutomator;
import com.codetaylor.mc.athenaeum.gui.ContainerBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class AutomatorContainer
extends ContainerBase {
    private final World world;
    private final TileAutomator tile;
    private EnumState state;
    private final int slotIndexPlayerInventoryStart;
    private final int slotIndexPlayerInventoryEnd;
    private final int slotIndexPlayerHotbarStart;
    private final int slotIndexPlayerHotbarEnd;
    private final int slotIndexTable;
    private final int slotIndexUpgradeStart;
    private final int slotIndexUpgradeEnd;
    private final int slotIndexPatternStart;
    private final int slotIndexPatternEnd;
    private final int slotIndexOutputStart;
    private final int slotIndexOutputEnd;
    private final int slotIndexInventoryStart;
    private final int slotIndexInventoryEnd;
    private final int slotIndexBucketStart;
    private final int slotIndexBucketEnd;
    private final int slotIndexToolStart;
    private final int slotIndexToolEnd;
    private final int slotIndexToolbox;
    private final int slotIndexToolUpgradeStart;
    private final int slotIndexToolUpgradeEnd;

    public AutomatorContainer(InventoryPlayer inventoryPlayer, World world, TileAutomator tile) {
        super(inventoryPlayer);
        int i;
        this.world = world;
        this.tile = tile;
        this.state = EnumState.Gear;
        this.slotIndexPlayerInventoryStart = this.nextSlotIndex;
        this.containerPlayerInventoryAdd();
        this.slotIndexPlayerInventoryEnd = this.nextSlotIndex - 1;
        this.slotIndexPlayerHotbarStart = this.nextSlotIndex;
        this.containerPlayerHotbarAdd();
        this.slotIndexPlayerHotbarEnd = this.nextSlotIndex - 1;
        this.slotIndexTable = this.nextSlotIndex;
        this.containerSlotAdd((Slot)new TableSlot(() -> this.state, EnumState.Gear, (IItemHandler)this.tile.getTableItemStackHandler(), 0, 26, 56));
        this.slotIndexUpgradeStart = this.nextSlotIndex;
        for (i = 0; i < 5; ++i) {
            this.containerSlotAdd((Slot)new PanelSlot(() -> this.state, EnumState.Gear, (IItemHandler)this.tile.getUpgradeItemStackHandler(), i, 71 + i * 18, 65));
        }
        this.slotIndexUpgradeEnd = this.nextSlotIndex - 1;
        this.slotIndexPatternStart = this.nextSlotIndex;
        for (i = 0; i < 9; ++i) {
            this.containerSlotAdd((Slot)new PanelSlot(() -> this.state, EnumState.Pattern, (IItemHandler)this.tile.getPatternItemStackHandler(), i, 8 + i * 18, 38));
        }
        this.slotIndexPatternEnd = this.nextSlotIndex - 1;
        this.slotIndexOutputStart = this.nextSlotIndex;
        for (i = 0; i < 9; ++i) {
            this.containerSlotAdd((Slot)new OutputPanelSlot(() -> this.state, EnumState.Pattern, (IItemHandler)this.tile.getOutputItemStackHandler(i), 0, 8 + i * 18, 56));
        }
        this.slotIndexOutputEnd = this.nextSlotIndex - 1;
        this.slotIndexInventoryStart = this.nextSlotIndex;
        for (i = 0; i < 26; ++i) {
            int x = i % 9;
            int y = i / 9;
            this.containerSlotAdd((Slot)new InventorySlot(() -> this.state, EnumState.Inventory, (IItemHandler)this.tile.getInventoryItemStackHandler(), i, 8 + x * 18, 38 + y * 18));
        }
        this.slotIndexInventoryEnd = this.nextSlotIndex - 1;
        this.slotIndexBucketStart = this.nextSlotIndex;
        for (i = 0; i < 3; ++i) {
            this.containerSlotAdd((Slot)new PanelSlot(() -> this.state, EnumState.Fluid, (IItemHandler)this.tile.getBucketItemStackHandler(), i, 8, 38 + i * 18));
        }
        this.slotIndexBucketEnd = this.nextSlotIndex - 1;
        this.slotIndexToolStart = this.nextSlotIndex;
        for (i = 0; i < 6; ++i) {
            this.containerSlotAdd((Slot)new PanelSlot(() -> this.state, EnumState.Tool, (IItemHandler)this.tile.getToolStackHandler(), i, 8 + i * 18, 38));
        }
        for (i = 6; i < 12; ++i) {
            this.containerSlotAdd((Slot)new PanelSlot(() -> this.state, EnumState.Tool, (IItemHandler)this.tile.getToolStackHandler(), i, 8 + (i - 6) * 18, 74));
        }
        this.slotIndexToolEnd = this.nextSlotIndex - 1;
        this.slotIndexToolbox = this.nextSlotIndex;
        this.containerSlotAdd((Slot)new ToolBoxPanelSlot(() -> this.state, EnumState.Tool, (IItemHandler)this.tile.getToolboxStackHandler(), this.tile.getToolUpgradeStackHandler(), this.tile.func_174877_v(), inventoryPlayer.field_70458_d, 0, 134, 56));
        this.slotIndexToolUpgradeStart = this.nextSlotIndex;
        for (i = 0; i < 6; ++i) {
            this.containerSlotAdd((Slot)new ToolUpgradePanelSlot(() -> this.state, EnumState.Tool, () -> !this.tile.getToolboxStackHandler().getStackInSlot(0).func_190926_b(), (IItemHandler)this.tile.getToolUpgradeStackHandler(), i, 8 + i * 18, 56));
        }
        this.slotIndexToolUpgradeEnd = this.nextSlotIndex - 1;
    }

    private boolean isSlotIndexPlayerInventory(int slotIndex) {
        return slotIndex >= this.slotIndexPlayerInventoryStart && slotIndex <= this.slotIndexPlayerInventoryEnd;
    }

    private boolean isSlotIndexPlayerHotbar(int slotIndex) {
        return slotIndex >= this.slotIndexPlayerHotbarStart && slotIndex <= this.slotIndexPlayerHotbarEnd;
    }

    private boolean isSlotIndexTable(int slotIndex) {
        return slotIndex == this.slotIndexTable;
    }

    private boolean isSlotIndexUpgrade(int slotIndex) {
        return slotIndex >= this.slotIndexUpgradeStart && slotIndex <= this.slotIndexUpgradeEnd;
    }

    private boolean isSlotIndexPattern(int slotIndex) {
        return slotIndex >= this.slotIndexPatternStart && slotIndex <= this.slotIndexPatternEnd;
    }

    private boolean isSlotIndexOutput(int slotIndex) {
        return slotIndex >= this.slotIndexOutputStart && slotIndex <= this.slotIndexOutputEnd;
    }

    private boolean isSlotIndexInventory(int slotIndex) {
        return slotIndex >= this.slotIndexInventoryStart && slotIndex <= this.slotIndexInventoryEnd;
    }

    private boolean isSlotIndexBucket(int slotIndex) {
        return slotIndex >= this.slotIndexBucketStart && slotIndex <= this.slotIndexBucketEnd;
    }

    private boolean isSlotIndexTool(int slotIndex) {
        return slotIndex >= this.slotIndexToolStart && slotIndex <= this.slotIndexToolEnd;
    }

    private boolean isslotIndexToolbox(int slotIndex) {
        return slotIndex == this.slotIndexToolbox;
    }

    private boolean isSlotIndexToolUpgrade(int slotIndex) {
        return slotIndex >= this.slotIndexToolUpgradeStart && slotIndex <= this.slotIndexToolUpgradeEnd;
    }

    private boolean mergePlayerInventory(ItemStack itemStack, boolean reverse) {
        return this.func_75135_a(itemStack, this.slotIndexPlayerInventoryStart, this.slotIndexPlayerInventoryEnd + 1, reverse);
    }

    private boolean mergePlayerHotbar(ItemStack itemStack, boolean reverse) {
        return this.func_75135_a(itemStack, this.slotIndexPlayerHotbarStart, this.slotIndexPlayerHotbarEnd + 1, reverse);
    }

    private boolean mergeTable(ItemStack itemStack) {
        return this.state == EnumState.Gear && this.func_75135_a(itemStack, this.slotIndexTable, this.slotIndexTable + 1, false);
    }

    private boolean mergeUpgrade(ItemStack itemStack) {
        return this.state == EnumState.Gear && this.func_75135_a(itemStack, this.slotIndexUpgradeStart, this.slotIndexUpgradeEnd + 1, false);
    }

    private boolean mergePattern(ItemStack itemStack) {
        return this.state == EnumState.Pattern && this.func_75135_a(itemStack, this.slotIndexPatternStart, this.slotIndexPatternEnd + 1, false);
    }

    private boolean mergeInventory(ItemStack itemStack) {
        return this.state == EnumState.Inventory && this.func_75135_a(itemStack, this.slotIndexInventoryStart, this.slotIndexInventoryEnd + 1, false);
    }

    private boolean mergeBucket(ItemStack itemStack) {
        return this.state == EnumState.Fluid && this.func_75135_a(itemStack, this.slotIndexBucketStart, this.slotIndexBucketEnd + 1, false);
    }

    private boolean mergeTool(ItemStack itemStack) {
        return this.state == EnumState.Tool && this.func_75135_a(itemStack, this.slotIndexToolStart, this.slotIndexToolEnd + 1, false);
    }

    private boolean mergeToolbox(ItemStack itemStack) {
        return this.state == EnumState.Tool && this.func_75135_a(itemStack, this.slotIndexToolbox, this.slotIndexToolbox + 1, false);
    }

    private boolean mergeToolUpgrade(ItemStack itemStack) {
        return this.state == EnumState.Tool && !this.tile.getToolboxStackHandler().getStackInSlot(0).func_190926_b() && this.func_75135_a(itemStack, this.slotIndexToolUpgradeStart, this.slotIndexToolUpgradeEnd + 1, false);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemStackCopy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack = slot.func_75211_c();
            itemStackCopy = itemStack.func_77946_l();
            if (this.isSlotIndexPlayerInventory(slotIndex) ? !this.mergeIntoDevice(itemStack) && !this.mergePlayerHotbar(itemStack, false) : (this.isSlotIndexPlayerHotbar(slotIndex) ? !this.mergeIntoDevice(itemStack) && !this.mergePlayerInventory(itemStack, false) : !this.mergePlayerHotbar(itemStack, false) && !this.mergePlayerInventory(itemStack, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStack.func_190916_E() == itemStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
        }
        return itemStackCopy;
    }

    private boolean mergeIntoDevice(ItemStack itemStack) {
        return this.mergeTable(itemStack) || this.mergeUpgrade(itemStack) || this.mergePattern(itemStack) || this.mergeInventory(itemStack) || this.mergeBucket(itemStack) || this.mergeTool(itemStack) || this.mergeToolbox(itemStack) || this.mergeToolUpgrade(itemStack);
    }

    protected int containerInventoryPositionGetY() {
        return 108;
    }

    protected int containerHotbarPositionGetY() {
        return 166;
    }

    public boolean setState(EnumState state) {
        if (this.state != state) {
            this.state = state;
            return true;
        }
        return false;
    }

    public EnumState getState() {
        return this.state;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public static enum EnumState {
        Gear(0),
        Pattern(1),
        Inventory(2),
        Fluid(3),
        Tool(4);

        private final int index;

        private EnumState(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumState fromIndex(int index) {
            for (EnumState value : EnumState.values()) {
                if (value.index != index) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown index: " + index);
        }
    }
}

