/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.event;

import com.codetaylor.mc.artisanautomation.modules.automator.TooltipUtil;
import com.codetaylor.mc.artisanautomation.modules.automator.item.ItemUpgrade;
import com.codetaylor.mc.athenaeum.util.TooltipHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TooltipEventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void on(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        NBTTagCompound upgradeTag = ItemUpgrade.getUpgradeTag(itemStack);
        boolean isToolUpgrade = false;
        if (upgradeTag == null) {
            upgradeTag = ItemUpgrade.getToolUpgradeTag(itemStack);
            if (upgradeTag == null) {
                return;
            }
            isToolUpgrade = true;
        }
        if (upgradeTag.func_186856_d() == 0) {
            return;
        }
        List tooltip = event.getToolTip();
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            if (isToolUpgrade) {
                this.addToolUpgradeTooltip(upgradeTag, tooltip);
            } else {
                this.addUpgradeTooltip(upgradeTag, tooltip);
            }
        } else {
            tooltip.add(TooltipHelper.tooltipHoldShiftStringGet());
        }
    }

    private void addToolUpgradeTooltip(NBTTagCompound upgradeTag, List<String> tooltip) {
        int energyUsageModifier;
        int durabilityRepaired;
        if (upgradeTag.func_74764_b("DurabilityRepaired") && (durabilityRepaired = (int)(upgradeTag.func_74760_g("DurabilityRepaired") * 100.0f)) > 0) {
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getDurabilityRepairedString(durabilityRepaired));
        }
        if (upgradeTag.func_74764_b("EnergyUsage") && (energyUsageModifier = (int)(upgradeTag.func_74760_g("EnergyUsage") * 100.0f)) != 0) {
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getEnergyUsageString(energyUsageModifier, true));
        }
    }

    private void addUpgradeTooltip(NBTTagCompound upgradeTag, List<String> tooltip) {
        int energyCapacityModifier;
        int fluidCapacityModifier;
        int energyUsageModifier;
        int speedModifier;
        if (upgradeTag.func_74764_b("Speed") && (speedModifier = (int)(upgradeTag.func_74760_g("Speed") * 100.0f)) != 0) {
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getSpeedString(speedModifier, true));
        }
        if (upgradeTag.func_74764_b("EnergyUsage") && (energyUsageModifier = (int)(upgradeTag.func_74760_g("EnergyUsage") * 100.0f)) != 0) {
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getEnergyUsageString(energyUsageModifier, true));
        }
        if (upgradeTag.func_74764_b("FluidCapacity") && (fluidCapacityModifier = (int)(upgradeTag.func_74760_g("FluidCapacity") * 100.0f)) != 0) {
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getFluidCapacityString(fluidCapacityModifier, true));
        }
        if (upgradeTag.func_74764_b("EnergyCapacity") && (energyCapacityModifier = (int)(upgradeTag.func_74760_g("EnergyCapacity") * 100.0f)) != 0) {
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getEnergyCapacityString(energyCapacityModifier, true));
        }
        if (upgradeTag.func_74764_b("AutoImportItems")) {
            boolean autoImportItems = upgradeTag.func_74767_n("AutoImportItems");
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getAutoImportItemsString(autoImportItems));
        }
        if (upgradeTag.func_74764_b("AutoExportItems")) {
            boolean autoExportItems = upgradeTag.func_74767_n("AutoExportItems");
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getAutoExportItemsString(autoExportItems));
        }
        if (upgradeTag.func_74764_b("AutoImportFluids")) {
            boolean autoImportFluids = upgradeTag.func_74767_n("AutoImportFluids");
            tooltip.add(TextFormatting.GRAY + TooltipUtil.getAutoImportFluidsString(autoImportFluids));
        }
    }
}

