/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator.block;

import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.ITileAutomatorBlock;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.ITileAutomatorPowerConsumer;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.supplier.ITileAutomatorPowerSupplier;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.supplier.TileAutomatorPowerSupplierRF;
import com.codetaylor.mc.artisanworktables.lib.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.FluidHelper;
import com.codetaylor.mc.athenaeum.util.FluidUtilFix;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockAutomatorPowerRF
extends BlockPartialBase {
    public static final String NAME = "automator_power_rf";
    private static final IProperty<EnumType> NORTH = PropertyEnum.func_177709_a((String)"north", EnumType.class);
    private static final IProperty<EnumType> SOUTH = PropertyEnum.func_177709_a((String)"south", EnumType.class);
    private static final IProperty<EnumType> EAST = PropertyEnum.func_177709_a((String)"east", EnumType.class);
    private static final IProperty<EnumType> WEST = PropertyEnum.func_177709_a((String)"west", EnumType.class);
    private static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final Map<EnumFacing, IProperty<EnumType>> PROPERTY_MAP = new EnumMap<EnumFacing, IProperty<EnumType>>(EnumFacing.class){
        {
            this.put(EnumFacing.NORTH, NORTH);
            this.put(EnumFacing.SOUTH, SOUTH);
            this.put(EnumFacing.EAST, EAST);
            this.put(EnumFacing.WEST, WEST);
        }
    };
    private static final AxisAlignedBB AABB = AABBHelper.create((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public BlockAutomatorPowerRF() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149752_b(10.0f);
        this.func_149711_c(1.5f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a(NORTH, (Comparable)((Object)EnumType.NONE)).func_177226_a(SOUTH, (Comparable)((Object)EnumType.NONE)).func_177226_a(EAST, (Comparable)((Object)EnumType.NONE)).func_177226_a(WEST, (Comparable)((Object)EnumType.NONE)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IFluidHandler fluidHandler;
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos.func_177984_a());
        return !(!(tileEntity instanceof ITileAutomatorPowerConsumer) && !(tileEntity instanceof ITileAutomatorPowerSupplier) || (fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) == null || !FluidHelper.drainWaterFromBottle((EntityPlayer)playerIn, (IFluidHandler)fluidHandler) && !FluidHelper.drainWaterIntoBottle((EntityPlayer)playerIn, (IFluidHandler)fluidHandler) && !FluidUtilFix.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)fluidHandler));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileAutomatorPowerSupplierRF) {
            ((TileAutomatorPowerSupplierRF)tileEntity).neighborChanged();
        }
    }

    public int getHarvestLevel(@Nonnull IBlockState state) {
        return 0;
    }

    @Nullable
    public String getHarvestTool(@Nonnull IBlockState state) {
        return "pickaxe";
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() == this) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof ITileAutomatorBlock) {
                boolean powered = ((ITileAutomatorBlock)tileEntity).isPowered();
                state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
            }
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                TileEntity tileEntity2 = world.func_175625_s(pos.func_177972_a(facing));
                if (tileEntity2 == null) continue;
                state = tileEntity2.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()) || tileEntity2.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) ? state.func_177226_a(PROPERTY_MAP.get(facing), (Comparable)((Object)EnumType.ITEM)) : (tileEntity2.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) ? state.func_177226_a(PROPERTY_MAP.get(facing), (Comparable)((Object)EnumType.POWER)) : state.func_177226_a(PROPERTY_MAP.get(facing), (Comparable)((Object)EnumType.NONE)));
            }
        }
        return super.func_176221_a(state, world, pos);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177230_c() == this;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileAutomatorPowerSupplierRF();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, NORTH, SOUTH, EAST, WEST});
    }

    public static enum EnumType implements IStringSerializable
    {
        NONE(0, "none"),
        POWER(1, "power"),
        ITEM(2, "item");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

