/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator;

import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.fluid.data.FluidHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.item.data.InventoryItemStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public final class Util {
    public static void consumeIngredientsFor(List<IArtisanIngredient> recipeIngredients, InventoryItemStackHandler inventoryItemStackHandler, @Nullable IItemHandler itemHandler) {
        block0: for (int i = 0; i < recipeIngredients.size(); ++i) {
            IArtisanIngredient recipeIngredient = recipeIngredients.get(i);
            int amount = recipeIngredient.getAmount();
            for (int j = 0; j < inventoryItemStackHandler.getSlots(); ++j) {
                ItemStack itemStack = inventoryItemStackHandler.getStackInSlot(j);
                if (!recipeIngredient.matchesIgnoreAmount(itemStack)) continue;
                if (itemStack.func_190916_E() >= amount) {
                    ItemStack extractItem = inventoryItemStackHandler.extractItem(j, amount, false);
                    if (itemHandler == null) continue block0;
                    itemHandler.insertItem(i, extractItem, false);
                    continue block0;
                }
                inventoryItemStackHandler.setStackInSlot(j, ItemStack.field_190927_a);
                amount -= itemStack.func_190916_E();
                itemStack.func_190920_e(0);
            }
        }
    }

    public static boolean hasIngredientsFor(List<IArtisanIngredient> recipeIngredients, List<IArtisanIngredient> recipeSecondaryIngredients, InventoryItemStackHandler inventoryItemStackHandler) {
        int inventorySlotCount = inventoryItemStackHandler.getSlots();
        ArrayList<ItemStack> inventoryCopy = new ArrayList<ItemStack>(inventorySlotCount);
        for (int i = 0; i < inventorySlotCount; ++i) {
            ItemStack itemStack = inventoryItemStackHandler.getStackInSlot(i);
            inventoryCopy.add(itemStack.func_77946_l());
        }
        return Util.hasIngredientsFor(recipeIngredients, inventoryCopy) && Util.hasIngredientsFor(recipeSecondaryIngredients, inventoryCopy);
    }

    private static boolean hasIngredientsFor(List<IArtisanIngredient> recipeIngredients, List<ItemStack> inventoryCopy) {
        for (IArtisanIngredient recipeIngredient : recipeIngredients) {
            if (recipeIngredient.isEmpty()) continue;
            int amount = recipeIngredient.getAmount();
            for (ItemStack itemStack : inventoryCopy) {
                if (!recipeIngredient.matchesIgnoreAmount(itemStack)) continue;
                if (itemStack.func_190916_E() >= amount) {
                    itemStack.func_190920_e(itemStack.func_190916_E() - amount);
                    amount = 0;
                    break;
                }
                amount -= itemStack.func_190916_E();
                itemStack.func_190920_e(0);
            }
            if (amount == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean consumeFluidsFor(FluidStack requiredFluid, FluidHandler[] fluidHandler) {
        if (requiredFluid == null || requiredFluid.amount == 0) {
            return true;
        }
        int requiredFluidAmount = requiredFluid.amount;
        for (FluidHandler handler : fluidHandler) {
            FluidStack availableFluid = handler.getFluid();
            if (availableFluid == null) continue;
            if (availableFluid.isFluidEqual(requiredFluid)) {
                if (availableFluid.amount >= requiredFluidAmount) {
                    handler.forceDrain(requiredFluidAmount);
                    return true;
                }
                handler.forceDrain(availableFluid.amount);
                requiredFluidAmount -= availableFluid.amount;
            }
            if (requiredFluidAmount != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFluidsFor(FluidStack requiredFluid, FluidHandler[] fluidHandler) {
        int requiredFluidAmount = requiredFluid.amount;
        for (FluidHandler handler : fluidHandler) {
            FluidStack availableFluid = handler.getFluid();
            if (availableFluid == null) continue;
            if (availableFluid.isFluidEqual(requiredFluid)) {
                if (availableFluid.amount >= requiredFluidAmount) {
                    return true;
                }
                requiredFluidAmount -= availableFluid.amount;
            }
            if (requiredFluidAmount != 0) continue;
            return true;
        }
        return false;
    }

    private Util() {
    }
}

