/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public final class TooltipUtil {
    public static String getAutoExportItemsString(boolean autoExportItems) {
        String prefix = autoExportItems ? TextFormatting.DARK_GREEN.toString() : TextFormatting.DARK_RED.toString();
        return I18n.func_135052_a((String)"tooltip.artisanautomation.automator.upgrade.auto.export.items", (Object[])new Object[]{prefix + autoExportItems});
    }

    public static String getAutoImportItemsString(boolean autoExportItems) {
        String prefix = autoExportItems ? TextFormatting.DARK_GREEN.toString() : TextFormatting.DARK_RED.toString();
        return I18n.func_135052_a((String)"tooltip.artisanautomation.automator.upgrade.auto.import.items", (Object[])new Object[]{prefix + autoExportItems});
    }

    public static String getAutoImportFluidsString(boolean autoExportItems) {
        String prefix = autoExportItems ? TextFormatting.DARK_GREEN.toString() : TextFormatting.DARK_RED.toString();
        return I18n.func_135052_a((String)"tooltip.artisanautomation.automator.upgrade.auto.import.fluids", (Object[])new Object[]{prefix + autoExportItems});
    }

    public static String getSpeedString(int speedModifier, boolean isUpgrade) {
        String prefix = TooltipUtil.getPrefix(speedModifier, isUpgrade);
        return I18n.func_135052_a((String)"tooltip.artisanautomation.automator.upgrade.speed", (Object[])new Object[]{prefix + speedModifier});
    }

    public static String getEnergyUsageString(int energyUsageModifier, boolean isUpgrade) {
        String prefix = TooltipUtil.getPrefixInverse(energyUsageModifier, isUpgrade);
        return I18n.func_135052_a((String)"tooltip.artisanautomation.automator.upgrade.energy.usage", (Object[])new Object[]{prefix + energyUsageModifier});
    }

    public static String getFluidCapacityString(int fluidCapacityModifier, boolean isUpgrade) {
        String prefix = TooltipUtil.getPrefix(fluidCapacityModifier, isUpgrade);
        return I18n.func_135052_a((String)"tooltip.artisanautomation.automator.upgrade.fluid.capacity", (Object[])new Object[]{prefix + fluidCapacityModifier});
    }

    public static String getEnergyCapacityString(int energyCapacityModifier, boolean isUpgrade) {
        String prefix = TooltipUtil.getPrefix(energyCapacityModifier, isUpgrade);
        return I18n.func_135052_a((String)"tooltip.artisanautomation.automator.upgrade.energy.capacity", (Object[])new Object[]{prefix + energyCapacityModifier});
    }

    public static String getDurabilityRepairedString(int durabilityPercentage) {
        return I18n.func_135052_a((String)"tooltip.artisanautomation.automator.upgrade.tool.repair.durability", (Object[])new Object[]{TextFormatting.DARK_GREEN.toString() + durabilityPercentage});
    }

    private static String getPrefix(int modifier, boolean isUpgrade) {
        int zero;
        String prefix = "";
        int n = zero = isUpgrade ? 0 : 100;
        if (modifier == zero) {
            if (isUpgrade) {
                prefix = "+";
            }
        } else {
            prefix = modifier > zero ? TextFormatting.DARK_GREEN.toString() + (isUpgrade ? "+" : "") : TextFormatting.DARK_RED.toString();
        }
        return prefix;
    }

    private static String getPrefixInverse(int modifier, boolean isUpgrade) {
        int zero;
        String prefix = "";
        int n = zero = isUpgrade ? 0 : 100;
        if (modifier == zero) {
            if (isUpgrade) {
                prefix = "+";
            }
        } else {
            prefix = modifier > zero ? TextFormatting.DARK_RED.toString() + (isUpgrade ? "+" : "") : TextFormatting.DARK_GREEN.toString();
        }
        return prefix;
    }

    private TooltipUtil() {
    }
}

